% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{test_incidence_fit}
\alias{test_incidence_fit}
\title{Test homogeneous Poisson assumption of disease incidence.}
\usage{
test_incidence_fit(inc, N_sim = 1e+05)
}
\arguments{
\item{inc}{Vector of absolute incidence values for each included year
of the registry as generated by \code{\link{yearly_incidence}}.}

\item{N_sim}{Number of simulations to perform.}
}
\value{
Vector of p-values for over- and under-dispersion based on the
  position of the observed sequence variance in the distribution.
}
\description{
This function compares the actual variance of the yearly incidence rates with
rates simulated from a Poisson process with overall rate equal to the overall
mean rate.
}
\examples{
data(prevsim)

inc <- yearly_incidence(prevsim$entrydate)

test_incidence_fit(inc)
}
\seealso{
Other incidence functions: \code{\link{incidence_age_distribution}},
  \code{\link{incidence}},
  \code{\link{mean_incidence_rate}},
  \code{\link{plot.incidence}},
  \code{\link{raw_incidence}},
  \code{\link{yearly_incidence}}
}
