% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit.prev.R
\name{survfit.prevalence}
\alias{survfit.prevalence}
\title{Form bootstrapped survival curves.}
\usage{
\method{survfit}{prevalence}(formula, newdata = NULL, ...)
}
\arguments{
\item{formula}{A \code{prevalence} object.}

\item{newdata}{A list or dataframe with the covariate values to calculate
survival probabilities for. Defaults to using the mean values from the the
original dataset that the model was fit to.}

\item{...}{Other arguments to \code{survfit}.}
}
\value{
An S3 object of class \code{survfit.prev} with the following
  attributes: \item{time}{A vector of time points at which survival
  probability has been calculated.} \item{surv}{A matrix of survival
  probabilities, where the rows represent a different bootstrapped Weibull
  model, and the columns are each timepoint.} \item{fullsurv}{A vector of
  survival probabilities for the predictors provided in newdata.}
}
\description{
Calculates bootstrapped survival probabilities from the Weibull models fitted
to the \code{prevalence} object.
}
\examples{
data(prevsim)

\dontrun{
prev_obj <- prevalence(Surv(time, status) ~ age(age) + sex(sex) +
                       entry(entrydate) + event(eventdate),
                       data=prevsim, num_years_to_estimate = c(5, 10),
                       population_size=1e6, start = "2005-09-01",
                       num_reg_years = 8, cure = 5)

survobj <- survfit(prev_obj)

survobj <- survfit(prev_obj, newdata=list(age=65, sex=0))
}

}
