\name{set.rate.matrix.tm}
\alias{set.rate.matrix.tm}
\title{Set the rate matrix of a tree model using model-specific parameters.}
\usage{set.rate.matrix.tm(x, params=NULL, scale=TRUE)
}
\description{Set the rate matrix of a tree model using model-specific parameters.}
\details{The params argument is a numeric vector with the parameters specific to the
model being used.  Here is the meaning of params for each model:
\itemize{
\item{"JC69","F81": These models have no parameters; params should be NULL.}
\item{"K80","HKY85": params should be a single value representing the
transition-transversion ratio (kappa).}
\item{"HKY85+Gap": params should be a numeric vector of length 2; the first
element represents the transition/transversion ratio (kappa), and the second
is the "gap parameter", the factor by which substitution rates are
multiplied if they involve an indel event.}
\item{"REV": params should be a numeric vector of length 6 (assuming a
model with 4 states).  With n states the vector should be of length
n*(n-1)/2.  The first parameter applies to the entry in the 1st row, 2nd
column; the next to the 1st row, 3rd column, etc until the end of the
first row; the next parameter applies to the 2nd row, 3rd column; etc.}
\item{"SSREV": params should be a numeric vector of length 4. Assuming
an alphabet "ACGT", the first parameter is the substitution rate from A->C,
C->A, T->G, and G->T.  The second is the rate from A->G, G->A, T->C,
and C->T,  The third is the rate from A->T and T->A, and the last is
C->G and G->C.}
\item{"UNREST": params should be a numeric vector of length n*n-n (where
n is the number of states.  params fills in the rate matrix starting at
the first row going across, skipping diagonals.}
\item{"R2": Parameters should be a numeric vector of length 48.  There
are 16 states in order AA, AC, AG, AT, CA, ..., TT (assuming alphabet
order ACGT).  Parameters are filled in starting row 1, column 2, going
across and then down, filling in the matrix above the diagonal, and
reflecting into the matrix below the diagonal.  Only cells which
represent a substitution which requires exactly one mutation are filled
in; cells requiring greater than 1 mutation have rate 0.}
\item{"U2": Similar to R2, except parameters are a numeric vector of
length 96.  Parameters are filled in starting row 1, column to, going
across and then down, filling entire matrix (rather than refelcting
across the diagonal)}
\item{"R2S": Similar to R2, but with strand symmetry.  params should be a
vector of length 24.  Parameters are filled in a similar fashion as R2,
except the same parameter applies to substitutions which are strand
symmetric.}
\item{"U2S": Similar to U2, but with strand symmetry.  params should be a
vector of length 48.  Parameters are filled in a similar fashion as U2,
except the same parameter applies to substitutions which are strand
symmetric.}
\item{"R3","R3S","U3","U3S": Similar to R2, R2S, U2, and U2S, except there
are 64 states instead of 16.  params should be numeric vector of length
288, 148, 576, or 288, for models R3, R3S, U3, and U3S respectively.}}}
\value{An object of type \code{tm} with a rate matrix set according
to params.}
\author{Melissa J. Hubisz and Adam Siepel}
\arguments{\item{x}{An object of type \code{tm}.}
\item{params}{Parameters specific to the substitution model.  Should be a
numeric vector of length appropriate for the model.  See details below.}
\item{scale}{A logical value.  If \code{TRUE}, scale the matrix so that the
expected number of mutations per unit time is one per base pair.}
}

