% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_utilities.R
\name{utilitiesForSurvivalTrials}
\alias{utilitiesForSurvivalTrials}
\alias{getLambdaByPi}
\alias{getLambdaByMedian}
\alias{getHazardRatioByPi}
\alias{getPiByLambda}
\alias{getPiByMedian}
\alias{getMedianByLambda}
\alias{getMedianByPi}
\title{Survival Helper Functions for Conversion of Pi, Lambda, Median}
\usage{
getLambdaByPi(piValue, eventTime = 12, kappa = 1)

getLambdaByMedian(median, kappa = 1)

getHazardRatioByPi(pi1, pi2, eventTime = 12, kappa = 1)

getPiByLambda(lambda, eventTime = 12, kappa = 1)

getPiByMedian(median, eventTime = 12, kappa = 1)

getMedianByLambda(lambda, kappa = 1)

getMedianByPi(piValue, eventTime = 12, kappa = 1)
}
\arguments{
\item{piValue, pi1, pi2, lambda, median}{Value that shall be converted.}

\item{eventTime}{The assumed time under which the event rates are calculated, default is \code{12}.}

\item{kappa}{A numeric value > 0. A \code{kappa != 1} will be used for the specification 
of the shape of the Weibull distribution. 
Default is \code{1}, i.e., the exponential survival distribution is used instead of the Weibull distribution.
Note that the Weibull distribution cannot be used for the piecewise definition of 
the survival time distribution, i.e., only \code{piecewiselambda} (as a single value) and \code{kappa} 
can be specified.
This function is equivalent to \code{pweibull(t, shape = kappa, scale = 1 / lambda)} 
of the \code{stats} package, i.e., the scale parameter is \code{1 / 'hazard rate'}.\cr
For example, 
\code{getPiecewiseExponentialDistribution(time = 130, piecewiseLambda = 0.01, kappa = 4.2)} 
and \code{pweibull(q = 130, shape = 4.2, scale = 1 / 0.01)} provide the sample result.}
}
\value{
Returns a \code{\link[base]{numeric}} value or vector will be returned.
}
\description{
Functions to convert pi, lambda and median values into each other.
}
\details{
Can be used, e.g., to convert median values into pi or lambda values for usage in
\code{\link[=getSampleSizeSurvival]{getSampleSizeSurvival()}} or \code{\link[=getPowerSurvival]{getPowerSurvival()}}.
}
