% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_rates.R
\name{getSimulationRates}
\alias{getSimulationRates}
\title{Get Simulation Rates}
\usage{
getSimulationRates(design = NULL, ..., groups = 2L,
  riskRatio = FALSE, thetaH0 = ifelse(riskRatio, 1, 0),
  pi1 = C_PI_1_DEFAULT, pi2 = NA_real_, plannedSubjects = NA_real_,
  directionUpper = C_DIRECTION_UPPER_DEFAULT,
  allocationRatioPlanned = NA_real_,
  minNumberOfAdditionalSubjectsPerStage = NA_real_,
  maxNumberOfAdditionalSubjectsPerStage = NA_real_,
  conditionalPower = NA_real_, pi1H1 = NA_real_, pi2H1 = 0.2,
  maxNumberOfIterations = C_MAX_SIMULATION_ITERATIONS_DEFAULT,
  seed = NA_real_, calcSubjectsFunction = NULL)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, \code{alpha}, \code{beta}, and \code{sided} can be directly entered as argument.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{riskRatio}{If \code{riskRatio = TRUE} is specified, the design characteristics for 
one-sided testing of H0: pi1/pi2 = thetaH0 are simulated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value. For one-sided testing, a value != 0 
(or a value != 1 for testing the mean ratio) can be specified, default is 
\code{0} or \code{1} for difference and ratio testing, respectively.}

\item{pi1}{The assumed probability in the active treatment group if two treatment groups 
are considered, or the alternative probability for a one treatment group design, 
default is \code{seq(0.2,0.5,0.1)}.}

\item{pi2}{The assumed probability in the reference group if two treatment groups are considered, default is \code{0.2}.}

\item{plannedSubjects}{\code{plannedSubjects} is a vector of length kMax (the number of stages of the design) 
that determines the number of cumulated (overall) subjects when the interim stages are planned.}

\item{directionUpper}{Specifies the direction of the alternative, only applicable 
for one-sided testing, default is \code{TRUE}.}

\item{allocationRatioPlanned}{The planned allocation ratio for a two treatment groups 
design, default is \code{1}.}

\item{minNumberOfAdditionalSubjectsPerStage}{When performing a data driven sample size recalculation, 
   the vector with length kMax \code{minNumberOfAdditionalSubjectsPerStage} determines the 
minimum number of subjects per stage (i.e., not cumulated), the first element 
is not taken into account.}

\item{maxNumberOfAdditionalSubjectsPerStage}{When performing a data driven sample size recalculation, 
   the vector with length kMax \code{maxNumberOfAdditionalSubjectsPerStage} determines the maximum number 
of subjects per stage (i.e., not cumulated), the first element is not taken into account.}

\item{conditionalPower}{The conditional power under which the sample size recalculation is performed.}

\item{pi1H1}{If specified, the assumed probability in the active treatment group if two treatment groups 
are considered, or the assumed probability for a one treatment group design, for which the conditional 
   power was calculated.}

\item{pi2H1}{If specified, the assumed probability in the reference group if two treatment groups 
are considered, for which the conditional power was calculated, default is \code{0.2}.}

\item{maxNumberOfIterations}{The number of simulation iterations.}

\item{seed}{The seed to reproduce the simulation, default is a random seed.}

\item{calcSubjectsFunction}{Optionally, a function can be entered that defines the way of performing the sample size
recalculation. By default, sample size recalulation is performed with conditional power and specified
\code{minNumberOfAdditionalSubjectsPerStage} and \code{maxNumberOfAdditionalSubjectsPerStage} (see details
and examples).}
}
\value{
Returns a \code{\link{SimulationResultsRates}} object.
}
\description{
Returns the simulated power, stopping probabilities, conditional power, and expected sample size for 
testing rates in a one or two treatment groups testing situation.
}
\details{
At given design the function simulates the power, stopping probabilities, conditional power, and expected 
sample size at given number of subjects and parameter configuration. 
Additionally, an allocation ratio = n1/n2 can be specified where n1 and n2 are the number 
of subjects in the two treatment groups.

calcSubjectsFunction\cr 
This function returns the number of subjects at given conditional power and conditional Type I error rate for specified 
testing situation. The function might depend on variables \code{stage}, \code{riskRatio}, \code{thetaH0}, \code{groups}, 
\code{plannedSubjects}, \code{directionUpper}, \code{allocationRatioPlanned}, \code{minNumberOfAdditionalSubjectsPerStage}, 
\code{maxNumberOfAdditionalSubjectsPerStage}, \code{sampleSizesPerStage}, \code{conditionalPower}, 
\code{conditionalCriticalValue}, \code{overallRate}, \code{farringtonManningValue1}, and \code{farringtonManningValue2}.
The function has to obtain the three-dots arument '...' (see examples).
}
\section{Simulation Data}{

The summary statistics "Simulated data" contains the following parameters: median [range]; mean +/-sd\cr

\code{$show(showStatistics = FALSE)} or \code{$setShowStatistics(FALSE)} can be used to disable 
the output of the aggregated simulated data.\cr

Example 1: \cr
\code{simulationResults <- getSimulationRates(plannedSubjects = 40)} \cr
\code{simulationResults$show(showStatistics = FALSE)}\cr

Example 2: \cr
\code{simulationResults <- getSimulationRates(plannedSubjects = 40)} \cr
\code{simulationResults$setShowStatistics(FALSE)}\cr
\code{simulationResults}\cr

\code{\link{getData}} can be used to get the aggregated simulated data from the 
object as \code{\link[base]{data.frame}}. The data frame contains the following columns:
\enumerate{
  \item \code{iterationNumber}: The number of the simulation iteration.
  \item \code{stageNumber}: The stage.
  \item \code{pi1}: The assumed or derived event rate in the treatment group (if available).
  \item \code{pi2}: The assumed or derived event rate in the control group (if available).
  \item \code{numberOfSubjects}: The number of subjects under consideration when the 
        (interim) analysis takes place.
  \item \code{rejectPerStage}: 1 if null hypothesis can be rejected, 0 otherwise. 
  \item \code{futilityPerStage}: 1 if study should be stopped for futility, 0 otherwise.
  \item \code{testStatistic}: The test statistic that is used for the test decision, 
        depends on which design was chosen (group sequential, inverse normal, 
        or Fisher combination test)'
  \item \code{testStatisticsPerStage}: The test statistic for each stage if only data from
			the considered stage is taken into account. 
  \item \code{overallRates1}: The overall rate in treatment group 1.
  \item \code{overallRates2}: The overall rate in treatment group 2.
  \item \code{stagewiseRates1}: The stagewise rate in treatment group 1.
  \item \code{stagewiseRates2}: The stagewise rate in treatment group 2.
  \item \code{sampleSizesPerStage1}: The stagewise sample size in treatment group 1.
  \item \code{sampleSizesPerStage2}: The stagewise sample size in treatment group 2.
  \item \code{trialStop}: \code{TRUE} if study should be stopped for efficacy or futility or final stage, \code{FALSE} otherwise.  
  \item \code{conditionalPowerAchieved}: The conditional power for the subsequent stage of the trial for 
			selected sample size and effect. The effect is either estimated from the data or can be
			user defined with \code{pi1H1} and \code{pi2H1}.   
}
}

\examples{

# Fixed sample size with minimum required definitions, pi1 = (0.3,0.4,0.5, 0.6) and pi2 = 0.3
getSimulationRates(pi1 = seq(0.3, 0.6, 0.1), pi2 = 0.3, 
    plannedSubjects = 120, maxNumberOfIterations = 50)

\donttest{

# Increase number of simulation iterations and compare results with power calculator
getSimulationRates(pi1 = seq(0.3, 0.6, 0.1), pi2 = 0.3, 
    plannedSubjects = 120, maxNumberOfIterations = 50)
getPowerRates(pi1 = seq(0.3, 0.6, 0.1), pi2 = 0.3, maxNumberOfSubjects = 120)

# Do the same for a two-stage Pocock inverse normal group sequential 
# design with non-binding futility stops
designIN <- getDesignInverseNormal(typeOfDesign = "P", futilityBounds = c(0))
getSimulationRates(designIN, pi1 = seq(0.3, 0.6, 0.1), pi2 = 0.3, 
    plannedSubjects = c(40, 80), maxNumberOfIterations = 50)
getPowerRates(designIN, pi1 = seq(0.3, 0.6, 0.1), pi2 = 0.3, maxNumberOfSubjects = 80)

# Assess power and average sample size if a sample size reassessment is 
# foreseen at conditional power 80\% for the subsequent stage (decrease and increase) 
# based on observed overall rates and specified minNumberOfAdditionalSubjectsPerStage 
# and maxNumberOfAdditionalSubjectsPerStage

# Do the same under the assumption that a sample size increase only takes place 
# if the rate difference exceeds the value 0.1 at interim. For this, the sample 
# size recalculation method needs to be redefined:  
mySampleSizeCalculationFunction <- function(..., stage,
        plannedSubjects,
        minNumberOfAdditionalSubjectsPerStage,
        maxNumberOfAdditionalSubjectsPerStage,
        conditionalPower,
        conditionalCriticalValue,
        overallRate) {
    if (overallRate[1] - overallRate[2] < 0.1) {
        return(plannedSubjects[stage] - plannedSubjects[stage - 1]) 
    } else {
        rateUnderH0 <- (overallRate[1] + overallRate[2]) / 2 
        stageSubjects <- 2 * (max(0, conditionalCriticalValue * 
            sqrt(2 * rateUnderH0 * (1 - rateUnderH0)) + 
            stats::qnorm(conditionalPower) * sqrt(overallRate[1] * 
            (1 - overallRate[1]) + overallRate[2] * (1 - overallRate[2]))))^2 /
            (max(1e-12,	(overallRate[1] - overallRate[2])))^2
        stageSubjects <- ceiling(min(max(
            minNumberOfAdditionalSubjectsPerStage[stage], 
            stageSubjects), maxNumberOfAdditionalSubjectsPerStage[stage]))
        return(stageSubjects)
    }	
}
getSimulationRates(designIN, pi1 = seq(0.3, 0.6, 0.1), pi2 = 0.3, 
    plannedSubjects = c(40, 80), minNumberOfAdditionalSubjectsPerStage = c(40, 20), 
    maxNumberOfAdditionalSubjectsPerStage = c(40, 160), conditionalPower = 0.8, 
    calcSubjectsFunction = mySampleSizeCalculationFunction, maxNumberOfIterations = 50)

}

}
