% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_tilespec.R
\name{register_tile_source}
\alias{get_default_tile_source}
\alias{register_tile_source}
\alias{set_default_tile_source}
\title{Register Tile Sources}
\usage{
register_tile_source(...)

set_default_tile_source(x, ...)

get_default_tile_source()
}
\arguments{
\item{...}{Passed to \link{as.tile_source} for set_default_tile_source, or a named
list of tile sources for register_tile_source}

\item{x}{The tile source (or coercible string) to use as the default tile source}
}
\description{
Use this function to register tile sources so they can be referred to by name in
\link{osm.plot}. Tile sources will be registered for as long as the namespace
is loaded. Use \code{set_default_tile_source()} to set the default source.
}
\examples{
# set the default tile source
set_default_tile_source("stamenbw")

# register a custom tile source
register_tile_source(dark = "http://a.basemaps.cartocdn.com/dark_all/${z}/${x}/${y}.png")

\donttest{
library(prettymapr)
ns <- makebbox(47.2, -59.7, 43.3, -66.4)
prettymap(osm.plot(ns, "dark"))
}

}

