% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/incomplete.R
\name{findSolutionWithIncomplete}
\alias{findSolutionWithIncomplete}
\title{Find single value function from incomplete preference information}
\usage{
findSolutionWithIncomplete(problem, stochasticResults, method, reg = 1e-20,
  accuracy = 1e-10)
}
\arguments{
\item{problem}{Problem to investigate.}

\item{stochasticResults}{Stochastic results (see \code{\link{calculateStochasticResults}}).}

\item{method}{\code{cai-product}, \code{apoi-product}, or \code{combined-product}.}

\item{reg}{Reg}

\item{accuracy}{Accuracy}
}
\value{
List with named elements:
\itemize{
\item \code{vf} - list of 2-column matrices with marginal value functions (characteristic point in rows),
\item \code{thresholds},
\item \code{assignments},
\item \code{alternativeValues},
\item \code{epsilon}.
}
}
\description{
This function finds a single value function from incomplete preference information for a problem.
}
\examples{
perf <- matrix(c(5, 2, 1, 7, 0.5, 0.9, 0.4, 0.4), ncol = 2)
problem <- buildProblem(perf, 3, FALSE, c('g', 'g'), c(0, 0))
problem <- addAssignmentsLB(problem, c(1, 2), c(2, 3))

stochasticResults <- calculateStochasticResults(problem, 100)
representativeFunction <- findSolutionWithIncomplete(problem, stochasticResults, "cai-product")
assignments <- representativeFunction$assignments
}
\seealso{
\code{\link{calculateStochasticResults}}
\code{\link{findRepresentativeFunction}}
\code{\link{plotComprehensiveValue}}
\code{\link{findSimpleFunction}}
}

