% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_services.R
\name{orcid_services}
\alias{orcid_services}
\title{Get services}
\usage{
orcid_services(orcid, put_code = NULL, format = "application/json",
  summary = FALSE, ...)
}
\arguments{
\item{orcid}{(character) Orcid identifier(s), of the form
XXXX-XXXX-XXXX-XXXX. required.}

\item{put_code}{(character/integer) one or more put codes. up to
50. optional}

\item{format}{(character) Name of the content-type format. One of
"application/vnd.orcid+xml; qs=5", "application/orcid+xml; qs=3",
"application/xml", "application/vnd.orcid+json; qs=4",
"application/orcid+json; qs=2", "application/json"
"application/vnd.citationstyles.csl+json". optional}

\item{summary}{(logical) get education summary for a put code.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
A list of results for each Orcid ID passed in, with each element
named by the Orcid ID
}
\description{
Get services
}
\details{
This function is vectorized, so you can pass in many ORCID's, and
there's an element returned for each ORCID you put in.
}
\examples{
\dontrun{
res <- orcid_services(orcid = "0000-0002-1642-628X")
res$`0000-0002-1642-628X`
res$`0000-0002-1642-628X`$`last-modified-date`
res$`0000-0002-1642-628X`$`affiliation-group`
res$`0000-0002-1642-628X`$path
}
}
