% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_activities.R
\name{orcid_activities}
\alias{orcid_activities}
\title{Get activities for a person}
\usage{
orcid_activities(orcid, ...)
}
\arguments{
\item{orcid}{(character) Orcid identifier(s), of the form
XXXX-XXXX-XXXX-XXXX. required.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
A list of results for each Orcid ID passed in, with each element 
named by the Orcid ID
}
\description{
Get activities for a person
}
\details{
This function is vectorized, so you can pass in many ORCID's, and 
there's an element returned for each ORCID you put in.
}
\examples{
\dontrun{
res <- orcid_activities(orcid = "0000-0002-9341-7985")
res$`0000-0002-9341-7985`
names(res$`0000-0002-9341-7985`)
res$`0000-0002-9341-7985`$`last-modified`
res$`0000-0002-9341-7985`$`educations`
res$`0000-0002-9341-7985`$`fundings`
res$`0000-0002-9341-7985`$`peer-reviews`
res$`0000-0002-9341-7985`$`works`
}
}
