% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.r
\name{create_model}
\alias{create_model}
\title{Create a model from a Modelfile}
\usage{
create_model(model, modelfile, server = NULL)
}
\arguments{
\item{model}{name of the model to create}

\item{modelfile}{either a path to a model file to be read or the contents of
the model file as a character vector.}

\item{server}{URL to one or several Ollama servers (not the API). Defaults to
"http://localhost:11434".}
}
\value{
Nothing. Called to create a model on the Ollama server.
}
\description{
Create a model from a Modelfile
}
\details{
Custom models are the way to save your system message and model
parameters in a dedicated shareable way. If you use \code{show_model()}, you can
look at the configuration of a model in the column modelfile. To get more
information and a list of valid parameters, check out
\url{https://github.com/ollama/ollama/blob/main/docs/modelfile.md}. Most
options are also available through the \code{query} and \code{chat} functions, yet
are not persistent over sessions.
}
\examples{
modelfile <- system.file("extdata", "modelfile.txt", package = "rollama")
\dontrun{create_model("mario", modelfile)}
modelfile <- "FROM llama3.1\nSYSTEM You are mario from Super Mario Bros."
\dontrun{create_model("mario", modelfile)}
}
