% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_read.R
\name{read_flat_table_folder}
\alias{read_flat_table_folder}
\title{Import all flat table files in a folder}
\usage{
read_flat_table_folder(
  name,
  folder,
  sep = ",",
  page = NULL,
  unknown_value = NULL,
  same_columns = FALSE,
  snake_case = FALSE
)
}
\arguments{
\item{name}{A string, flat table name.}

\item{folder}{A string, folder name.}

\item{sep}{Column separator character.}

\item{page}{A string, name of the new field in which to include the name of
the file.}

\item{unknown_value}{A string, value used to replace empty and NA values in
attributes.}

\item{same_columns}{A boolean, indicates whether all tables have the same
columns in the same order.}

\item{snake_case}{A boolean, indicates if we want to transform the names of
the columns to snake case.}
}
\value{
A \code{flat_table} object.
}
\description{
Reads all text files in a folder and creates a \code{flat_table} object. Each file
is expected to contain a flat table, all with the same structure, whose first
row contains the name of the columns. All columns are considered to be of type
String.
}
\details{
When multiple files are handled, the file name may contain information
associated with the flat table, it could be the table page information if the
name of a new field in which to store it is indicated.

We can also indicate the value that is used in the data with undefined values.

In some situations all the files have the same structure but the column names
may change slightly. In these cases it can be useful to transform the names to
snake case or consider for all the files the names of the columns of the first
one. These operations can be indicated by the corresponding parameters.
}
\examples{

file <- system.file("extdata", package = "rolap")

ft <- read_flat_table_folder('mrs_new', file)

}
\seealso{
\code{\link{star_database}}

Other flat table definition functions: 
\code{\link{as_star_database}()},
\code{\link{flat_table}()},
\code{\link{get_table}()},
\code{\link{get_unknown_value_defined}()},
\code{\link{get_unknown_values}()},
\code{\link{read_flat_table_file}()}
}
\concept{flat table definition functions}
