% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_join.R
\name{lookup_table}
\alias{lookup_table}
\alias{lookup_table.flat_table}
\title{Transform a flat table into a look up table}
\usage{
lookup_table(
  ft,
  pk_attributes,
  attributes,
  attribute_agg,
  measures,
  measure_agg
)

\method{lookup_table}{flat_table}(
  ft,
  pk_attributes = NULL,
  attributes = NULL,
  attribute_agg = NULL,
  measures = NULL,
  measure_agg = NULL
)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{pk_attributes}{A vector of strings, attribute names.}

\item{attributes}{A vector of strings, rest of attribute names.}

\item{attribute_agg}{A vector of strings, attribute aggregation functions.}

\item{measures}{A vector of strings, measure names.}

\item{measure_agg}{A vector of strings, measure aggregation functions.}
}
\value{
A \code{flat_table} object.
}
\description{
Checks that the given attributes form a primary key of the table. Otherwise,
group the records so that they form a primary key. To carry out the groupings,
aggregation functions for attributes and measures must be provided.
}
\details{
If the table does not have measures, attributes with equal values are grouped
without the need to indicate a grouping function.

If no attribute is indicated, all the attributes are considered to form the
primary key.
}
\examples{

ft <- flat_table('iris', iris) |>
  lookup_table(
    measures = c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"),
    measure_agg = c('MAX', 'MIN', 'SUM', 'MEAN')
  )

}
\seealso{
\code{\link{flat_table}}

Other flat table join functions: 
\code{\link{check_lookup_table}()},
\code{\link{get_pk_attribute_names}()},
\code{\link{join_lookup_table}()}
}
\concept{flat table join functions}
