% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database_export.R
\name{as_single_tibble_list}
\alias{as_single_tibble_list}
\alias{as_single_tibble_list.star_database}
\title{Generate a list of tibbles of flat tables}
\usage{
as_single_tibble_list(db)

\method{as_single_tibble_list}{star_database}(db)
}
\arguments{
\item{db}{A \code{star_database} object.}
}
\value{
A list of \code{tibble}
}
\description{
Allows you to transform a star database into a flat table. If we have a
constellaton, it returns a list of flat tables.
}
\examples{

db1 <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
tl1 <- db1 |>
  as_single_tibble_list()

db2 <- star_database(mrs_age_schema, ft_age) |>
  snake_case()

ct <- constellation("MRS", list(db1, db2))
tl <- ct |>
  as_single_tibble_list()

}
\seealso{
\code{\link{star_database}}

Other star database exportation functions: 
\code{\link{as_dm_class}()},
\code{\link{as_tibble_list}()}
}
\concept{star database exportation functions}
