% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_coded_sources.R
\name{inspect_coded_sources}
\alias{inspect_coded_sources}
\title{Read sources from a directory, parse them, and show coded fragments and code tree}
\usage{
inspect_coded_sources(
  path,
  parse_args = list(extension = "rock|dct", regex = NULL, recursive = TRUE,
    ignoreOddDelimiters = FALSE, encoding = rock::opts$get("encoding"), silent =
    rock::opts$get("silent")),
  fragments_args = list(codes = ".*", context = 0),
  inductive_tree_args = list(codes = ".*", output = "both", headingLevel = 3),
  deductive_tree_args = list()
)
}
\arguments{
\item{path}{The path containing the sources to parse and inspect.}

\item{parse_args}{The arguments to pass to \code{\link[=parse_sources]{parse_sources()}}.}

\item{fragments_args}{The arguments to pass to \code{\link[=collect_coded_fragments]{collect_coded_fragments()}}.}

\item{inductive_tree_args}{The arguments to pass
to \code{\link[=show_inductive_code_tree]{show_inductive_code_tree()}}.}

\item{deductive_tree_args}{Not yet implemented.}
}
\value{
The parsedSources object.
}
\description{
This function combines successive calls to \code{\link[=parse_sources]{parse_sources()}},
\code{\link[=collect_coded_fragments]{collect_coded_fragments()}} and \code{\link[=show_inductive_code_tree]{show_inductive_code_tree()}}.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Inspect sources
rock::inspect_coded_sources(examplePath);
}
