% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tslars.R
\name{tslars}
\alias{tslars}
\alias{print.tslars}
\alias{tslars.formula}
\alias{tslars.default}
\alias{rtslars}
\alias{rtslars.formula}
\alias{rtslars.default}
\title{(Robust) least angle regression for time series data}
\usage{
tslars(x, ...)

\method{tslars}{formula}(formula, data, ...)

\method{tslars}{default}(x, y, h = 1, pMax = 3, sMax = NA,
  fit = TRUE, s = c(0, sMax), crit = "BIC", ncores = 1,
  cl = NULL, model = TRUE, ...)

rtslars(x, ...)

\method{rtslars}{formula}(formula, data, ...)

\method{rtslars}{default}(x, y, h = 1, pMax = 3, sMax = NA,
  centerFun = median, scaleFun = mad, regFun = lmrob,
  regArgs = list(), combine = c("min", "euclidean", "mahalanobis"),
  winsorize = FALSE, const = 2, prob = 0.95, fit = TRUE, s = c(0,
  sMax), crit = "BIC", ncores = 1, cl = NULL, seed = NULL,
  model = TRUE, ...)
}
\arguments{
\item{x}{a numeric matrix or data frame containing the candidate predictor
series.}

\item{\dots}{additional arguments to be passed down.}

\item{formula}{a formula describing the full model.}

\item{data}{an optional data frame, list or environment (or object coercible
to a data frame by \code{\link{as.data.frame}}) containing the variables in
the model.  If not found in data, the variables are taken from
\code{environment(formula)}, typically the environment from which
\code{tslars} or \code{rtslars} is called.}

\item{y}{a numeric vector containing the response series.}

\item{h}{an integer giving the forecast horizon (defaults to 1).}

\item{pMax}{an integer giving the maximum number of lags in the model
(defaults to 3).}

\item{sMax}{an integer giving the number of predictor series to be
sequenced.  If it is \code{NA} (the default), predictor groups are sequenced
as long as there are twice as many observations as predictor variables.}

\item{fit}{a logical indicating whether to fit submodels along the sequence
(\code{TRUE}, the default) or to simply return the sequence (\code{FALSE}).}

\item{s}{an integer vector of length two giving the first and last
step along the sequence for which to compute submodels.  The default
is to start with a model containing only an intercept (step 0) and
iteratively add all series along the sequence (step \code{sMax}).  If
the second element is \code{NA}, predictor groups are added to the
model as long as there are twice as many observations as predictor
variables.  If only one value is supplied, it is recycled.}

\item{crit}{a character string specifying the optimality criterion to be
used for selecting the final model.  Currently, only \code{"BIC"} for the
Bayes information criterion is implemented.}

\item{ncores}{a positive integer giving the number of processor cores to be
used for parallel computing (the default is 1 for no parallelization).  If
this is set to \code{NA}, all available processor cores are used.  For
each lag length, parallel computing for obtaining the data cleaning weights
and for fitting models along the sequence is implemented on the \R level
using package \pkg{parallel}.  Otherwise parallel computing for some of of
the more computer-intensive computations in the sequencing step is
implemented on the C++ level via OpenMP (\url{http://openmp.org/}).}

\item{cl}{a \pkg{parallel} cluster for parallel computing as generated by
\code{\link[parallel]{makeCluster}}.  This is preferred over \code{ncores}
for tasks that are parallelized on the \R level, in which case \code{ncores}
is only used for tasks that are parallelized on the C++ level.}

\item{model}{a logical indicating whether the model data should be included
in the returned object.}

\item{centerFun}{a function to compute a robust estimate for the center
(defaults to \code{\link[stats]{median}}).}

\item{scaleFun}{a function to compute a robust estimate for the scale
(defaults to \code{\link[stats]{mad}}).}

\item{regFun}{a function to compute robust linear regressions that can be
interpreted as weighted least squares (defaults to
\code{\link[robustbase]{lmrob}}).}

\item{regArgs}{a list of arguments to be passed to \code{regFun}.}

\item{combine}{a character string specifying how to combine the data
cleaning weights from the robust regressions with each predictor group.
Possible values are \code{"min"} for taking the minimum weight for each
observation, \code{"euclidean"} for weights based on Euclidean distances
of the multivariate set of standardized residuals (i.e., multivariate
winsorization of the standardized residuals assuming independence), or
\code{"mahalanobis"} for weights based on Mahalanobis distances of the
multivariate set of standardized residuals (i.e., multivariate winsorization
of the standardized residuals).}

\item{winsorize}{a logical indicating whether to clean the data by
multivariate winsorization.}

\item{const}{numeric; tuning constant for multivariate winsorization to be
used in the initial corralation estimates based on adjusted univariate
winsorization (defaults to 2).}

\item{prob}{numeric; probability for the quantile of the
\eqn{\chi^{2}}{chi-squared} distribution to be used in multivariate
winsorization (defaults to 0.95).}

\item{seed}{optional initial seed for the random number generator
(see \code{\link{.Random.seed}}), which is useful because many robust
regression functions (including \code{\link[robustbase]{lmrob}}) involve
randomness.  On parallel \R worker processes, random number streams are
used and the seed is set via \code{\link{clusterSetRNGStream}}.}
}
\value{
If \code{fit} is \code{FALSE}, an integer matrix in which each column
contains the indices of the sequenced predictor series for the corresponding
lag length.

Otherwise an object of class \code{"tslars"} with the following components:
\describe{
  \item{\code{pFit}}{a list containing the fits for the respective lag
  lengths (see \code{\link{tslarsP}}).}
  \item{\code{pOpt}}{an integer giving the optimal number of lags.}
  \item{\code{pMax}}{the maximum number of lags considered.}
  \item{\code{x}}{the matrix of candidate predictor series (if \code{model}
  is \code{TRUE}).}
  \item{\code{y}}{the response series (if \code{model} is \code{TRUE}).}
  \item{\code{call}}{the matched function call.}
}
}
\description{
(Robustly) sequence groups of candidate predictors and their respective
lagged values according to their predictive content and find the optimal
model along the sequence.  Note that lagged values of the response are
included as a predictor group as well.
}
\note{
The predictor group of lagged values of the response is indicated by
the index 0.
}
\references{
Gelper, S. and Croux, C. (2010) Time series least angle regression for
selecting predictive economic sentiment series. Working paper.
}
\seealso{
\code{\link[=coef.tslars]{coef}},
\code{\link[=fitted.tslars]{fitted}},
\code{\link[=plot.tslars]{plot}},
\code{\link[=predict.tslars]{predict}},
\code{\link[=residuals.tslars]{residuals}},
\code{\link{tslarsP}}, \code{\link[robustbase]{lmrob}}
}
\author{
Andreas Alfons, based on code by Sarah Gelper
}
\keyword{regression}
\keyword{robust}
\keyword{ts}
