% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{wt}
\alias{wt}
\alias{wt.sparseLTS}
\title{Extract outlier weights from sparse LTS regression models}
\usage{
wt(object, ...)

\method{wt}{sparseLTS}(object, s = NA, fit = c("reweighted", "raw", "both"),
  drop = !is.null(s), ...)
}
\arguments{
\item{object}{the model fit from which to extract outlier weights.}

\item{s}{an integer vector giving the indices of the models for which to
extract outlier weights.  If \code{fit} is \code{"both"}, this can be a list
with two components, with the first component giving the indices of the
reweighted fits and the second the indices of the raw fits.  The default is
to use the optimal model for each of the requested estimators.  Note that
the optimal models may not correspond to the same value of the penalty
parameter for the reweighted and the raw estimator.}

\item{fit}{a character string specifying for which estimator to extract
outlier weights.  Possible values are \code{"reweighted"} (the default) for
weights indicating outliers from the reweighted fit, \code{"raw"} for
weights indicating outliers from the raw fit, or \code{"both"} for the
outlier weights from both estimators.}

\item{drop}{a logical indicating whether to reduce the dimension to a
vector in case of only one model.}

\item{\dots}{currently ignored.}
}
\value{
A numeric vector or matrix containing the requested outlier weights.
}
\description{
Extract binary weights that indicate outliers from sparse least trimmed
squares regression models.
}
\note{
The weights are \eqn{1} for observations with reasonably small
residuals and \eqn{0} for observations with large residuals.
}
\examples{
## generate data
# example is not high-dimensional to keep computation time low
library("mvtnorm")
set.seed(1234)  # for reproducibility
n <- 100  # number of observations
p <- 25   # number of variables
beta <- rep.int(c(1, 0), c(5, p-5))  # coefficients
sigma <- 0.5      # controls signal-to-noise ratio
epsilon <- 0.1    # contamination level
Sigma <- 0.5^t(sapply(1:p, function(i, j) abs(i-j), 1:p))
x <- rmvnorm(n, sigma=Sigma)    # predictor matrix
e <- rnorm(n)                   # error terms
i <- 1:ceiling(epsilon*n)       # observations to be contaminated
e[i] <- e[i] + 5                # vertical outliers
y <- c(x \%*\% beta + sigma * e)  # response
x[i,] <- x[i,] + 5              # bad leverage points

## sparse LTS over a grid of values for lambda
# fit model
frac <- seq(0.2, 0.05, by = -0.05)
fitGrid <- sparseLTS(x, y, lambda = frac, mode = "fraction")
# extract outlier weights
wt(fitGrid)
head(wt(fitGrid, fit = "both"))
head(wt(fitGrid, s = NULL))
head(wt(fitGrid, fit = "both", s = NULL))
}
\author{
Andreas Alfons
}
\seealso{
\code{\link{sparseLTS}}
}
\keyword{regression}

