% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{mvn_sup}
\alias{mvn_sup}
\title{Multivariate normal supremum simulation}
\usage{
mvn_sup(n, mu, Sigma, seed = NULL)
}
\arguments{
\item{n}{An integer determining the number of draws from the multivariate
normal distribution.}

\item{mu}{A numeric vector representing the mean of the multivariate normal
distribution.}

\item{Sigma}{A numeric matrix representing the variance-covariance matrix of
the mutlivariate normal distribution.}

\item{seed}{An integer setting the random seed or \code{NULL} if it should
not be set.}
}
\value{
\code{mvn_sup} returns a vector of suprema of length \code{n}.
}
\description{
\code{mvn_sup} simulates the distribution of the supremum of the specified
multivariate normal distribution by drawing repeatedly from the multivariate
normal distribution and calculating the maximum of each vector.
}
