% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipse_plot.R
\name{ellipse_plot}
\alias{ellipse_plot}
\alias{ellipse_plot.default}
\alias{ellipse_plot.setup_ellipse_plot}
\title{Diagnostic plot with a tolerance ellipse}
\usage{
ellipse_plot(object, ...)

\method{ellipse_plot}{default}(object, horizontal = NULL,
  vertical = NULL, partial = FALSE, level = 0.975, npoints = 100,
  ...)

\method{ellipse_plot}{setup_ellipse_plot}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"\link{fit_mediation}"}
or \code{"\link{test_mediation}"} containing results from (robust) mediation
analysis, or a list of such objects.}

\item{\dots}{additional arguments to be passed down.}

\item{horizontal}{a character string specifying the variable to be
plotted on the horizontal axis.  If the dependent variable is chosen for
the vertical axis, a hypothsized mediator or the independent variable must
be selected for the horizontal axis.  If a hypothesized mediator is chosen
for the vertical axis, the independent variable must be selected for the
horizontal axis.  The default is to plot the independent variable on the
horizontal axis.}

\item{vertical}{a character string specifying the variable to be
plotted on the vertical axis: the dependent variable or a hypothesized
mediator.  The default is to plot the first hypothesized mediator on the
vertical axis.}

\item{partial}{a logical indicating whether the vertical axis should
display the observed values of the selected variable (\code{FALSE}), or
the partial residuals with respect to the variable on the horizontal axis
(\code{TRUE}).  The latter allows to display the corresponding regression
coefficient by a line.}

\item{level}{numeric; the confidence level of the tolerance ellipse.  It
gives the percentage of observations that are expected to lie within the
ellipse under the assumption of a normal distribution, and therefore it
controls the size of the ellipse.  The default is such that the ellipse is
expected to contain 97.5\% of the observations.}

\item{npoints}{The number of grid points used to evaluate and draw the
ellipse.  The default is to use 100 grid points.}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}.
}
\description{
Produce a scatter plot of two variables used in (robust) mediation analysis
together with a tolerance ellipse.  Exploiting the relationship between the
regression coefficients and the covariance matrix, that tolerance ellipse
illustrates how well the regression results represent the data. In addition,
a line that visualizes the estimated regression coefficient is added when
relevant.
}
\details{
A line to visualize the corresponding regression coefficient is added if
\code{partial = TRUE}, or in case of a simple mediation model
(without control variables) when the hypothesized mediator is plotted on
the vertical axis and the independent variable is plotted on the horizontal
axis.

For robust estimation methods that return outlyingness weights for each
data point, those weights are visualized by coloring the points on a grey
scale.  If a list of objects has been supplied and there are multiple
objects from such robust methods, each method is placed in a separate panel.

Methods first call \code{\link{setup_ellipse_plot}()} to extract all
necessary information to produce the plot, then the
\code{"setup_ellipse_plot"} method is called to produce the plot.
}
\examples{
data("BSG2014")

# run fast and robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# create plot for robust bootstrap test
ellipse_plot(robust_boot)

# original data and partial residuals
ellipse_plot(robust_boot, horizontal = "TaskConflict",
             vertical = "TeamCommitment")
ellipse_plot(robust_boot, horizontal = "TaskConflict",
             vertical = "TeamCommitment", partial = TRUE)

# run standard bootstrap test
standard_boot <- test_mediation(BSG2014,
                                x = "ValueDiversity",
                                y = "TeamCommitment",
                                m = "TaskConflict",
                                robust = FALSE)

# compare robust and standard tests
tests <- list(OLS = standard_boot, Robust = robust_boot)
ellipse_plot(tests)

# the plot can be customized in the usual way
ellipse_plot(tests) + theme_bw() +
  labs(title = "OLS vs robust estimation")

}
\seealso{
\code{\link{fit_mediation}()}, \code{\link{test_mediation}()},
\code{\link{setup_ellipse_plot}()}

\code{\link{ci_plot}()}, \code{\link{density_plot}()},
\code{\link[=plot-methods]{plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
