% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_plot.R
\name{ci_plot}
\alias{ci_plot}
\alias{ci_plot.default}
\alias{ci_plot.boot_test_mediation}
\alias{ci_plot.sobel_test_mediation}
\alias{ci_plot.list}
\alias{ci_plot.setup_ci_plot}
\title{Dot plot with confidence intervals}
\usage{
ci_plot(object, ...)

\method{ci_plot}{default}(object, parm = c("direct", "indirect"), ...)

\method{ci_plot}{boot_test_mediation}(
  object,
  parm = c("direct", "indirect"),
  type = c("boot", "data"),
  p_value = FALSE,
  digits = 4L,
  ...
)

\method{ci_plot}{sobel_test_mediation}(
  object,
  parm = c("direct", "indirect"),
  level = 0.95,
  p_value = FALSE,
  ...
)

\method{ci_plot}{list}(
  object,
  parm = c("direct", "indirect"),
  type = c("boot", "data"),
  level = 0.95,
  p_value = FALSE,
  digits = 4L,
  ...
)

\method{ci_plot}{setup_ci_plot}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class
\code{"\link{test_mediation}"} containing results from
(robust) mediation analysis, or a list of such objects.}

\item{\dots}{additional arguments to be passed down.}

\item{parm}{an integer, character or logical vector specifying which
effects to include in the plot.  In case of a character vector, possible
values are \code{"a"}, \code{"b"}, \code{"d"} (only serial multiple mediator
models), \code{"total"}, \code{"direct"}, and \code{"indirect"}.  The
default is to include the direct and the indirect effect(s).}

\item{type}{a character string specifying which point estimates and
confidence intervals to plot: those based on the bootstrap distribution
(\code{"boot"}; the default), or those based on the original data
(\code{"data"}).  If \code{"boot"}, the confidence intervals of effects
other than the indirect effect(s) are computed using a normal approximation
(i.e., assuming a normal distribution of the corresponding effect with the
standard deviation computed from the bootstrap replicates).  If
\code{"data"}, the confidence intervals of effects other than the indirect
effect(s) are computed via statistical theory based on the original data
(e.g., based on a t-distribution if the coefficients are estimated via
regression).  Note that this is only relevant for mediation analysis via a
bootstrap test, where the confidence interval of the indirect effect is
always computed via a percentile-based method due to the asymmetry of its
distribution.}

\item{p_value}{a logical indicating whether to include dot plots of the
p-values in addition to those with confidence intervals.  The default is
\code{FALSE}.}

\item{digits}{an integer determining how many digits to compute for
bootstrap p-values of the indirect effects (see \code{\link{p_value}()}).
The default is to compute 4 digits after the comma.  This is only relevant
if \code{p_value = TRUE}.}

\item{level}{numeric;  the confidence level of the confidence intervals
from Sobel's test.  The default is to include 95\% confidence intervals.
Note that this is not used for bootstrap tests, as those require to specify
the confidence level already in \code{\link{test_mediation}()}.}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}.
}
\description{
Produce a dot plot with confidence intervals of selected effects from
(robust) mediation analysis.  In addition to confidence intervals, p-values
of the selected effects can be plotted as well.
}
\details{
Methods first call \code{\link{setup_ci_plot}()} to extract all necessary
information to produce the plot, then the \code{"setup_ci_plot"}
method is called to produce the plot.
}
\examples{
data("BSG2014")

# run fast-and-robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# create plot for robust bootstrap test
ci_plot(robust_boot)
ci_plot(robust_boot, color = "#00BFC4")

# run OLS bootstrap test
ols_boot <- test_mediation(BSG2014,
                           x = "ValueDiversity",
                           y = "TeamCommitment",
                           m = "TaskConflict",
                           robust = FALSE)

# compare robust and OLS bootstrap tests
boot_list <- list("OLS bootstrap" = ols_boot,
                  "ROBMED" = robust_boot)
ci_plot(boot_list)

# the plot can be customized in the usual way
ci_plot(boot_list) +
  geom_hline(yintercept = 0, color = "darkgrey") +
  coord_flip() + theme_bw() +
  labs(title = "OLS bootstrap vs ROBMED")

}
\seealso{
\code{\link{test_mediation}()}, \code{\link{setup_ci_plot}()}

\code{\link{density_plot}()}, \code{\link{ellipse_plot}()},
\code{\link{weight_plot}()}, \code{\link[=plot-methods]{plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
