% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinGPTest}
\alias{robinGPTest}
\title{robinGPTest}
\usage{
robinGPTest(x, verbose = FALSE)
}
\arguments{
\item{x}{A robin class object. The output of the functions:
\code{\link{robinRobust}} and \code{\link{robinCompare}}.}

\item{verbose}{flag for verbose output (default as FALSE).}
}
\value{
A numeric value, the Bayes factor
}
\description{
This function implements the GP testing procedure and calculates the 
Bayes factor.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
comp <- robinCompare(graph=graph, method1="fastGreedy",method2="infomap")
\donttest{robinGPTest(comp)}
}
