% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinGPTest}
\alias{robinGPTest}
\title{robinGPTest}
\usage{
robinGPTest(model1, model2, verbose = FALSE)
}
\arguments{
\item{model1}{The Mean output of the robinRobust function (or the Mean1 
output of the robinCompare function).}

\item{model2}{The MeanRandom output of the robinRobust function (or the 
Mean2 output of the robinCompare function).}

\item{verbose}{flag for verbose output (default as FALSE).}
}
\value{
A numeric value, the Bayes factor
}
\description{
This function implements the GP testing procedure and calculates the 
Bayes factor.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
Proc <- robinRobust(graph=graph, graphRandom=graphRandom, 
method="louvain", measure="vi",type="independent")
robinGPTest(model1=Proc$Mean,model2=Proc$MeanRandom)
}
