% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{plotRobin}
\alias{plotRobin}
\title{plotRobin}
\usage{
plotRobin(graph, model1, model2, measure = c("vi", "nmi", "split.join",
  "adjusted.rand"), legend = c("model1", "model2"),
  title = "Robin plot")
}
\arguments{
\item{graph}{The output of prepGraph}

\item{model1}{The Mean output of the robinRobust function or the Mean1 
output of robinCompare.}

\item{model2}{The MeanRandom output of the robinRobust function or the Mean2 
output of robinCompare.}

\item{measure}{The stability measure "vi", "nmi", "split.join", 
"adjusted.rand".}

\item{legend}{The legend for the graph. The default is c("model1", 
"model2").}

\item{title}{The title for the graph. The default is "Robin plot".}
}
\value{
A ggplot object.
}
\description{
The plot of the two curves, the measures of the null model and 
of the real graph.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
Proc <- robinRobust(graph=graph, graphRandom=graphRandom, method="louvain",
type="independent")
plotRobin(graph=graph, model1=Proc$Mean, model2=Proc$MeanRandom,
measure="vi", legend=c("real data", "null model"))

}
