% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SigmaFunctions.R
\name{find_sigma1}
\alias{find_sigma1}
\title{The asymptotic efficiency constant \eqn{\sigma_1} of the t-MLE for scatter}
\usage{
find_sigma1(df_data, df_est, p)
}
\arguments{
\item{df_data}{A positive real number or \code{Inf}. The degrees of freedom of the
data-generationg t-distribution. \code{Inf} means normal distribution.}

\item{df_est}{A non-negative real number or \code{Inf}. The degrees of freedom of the
t-distribution the M-estimator is derived from.
\code{Inf} is the usual sample covariance, \code{0} is Tyler's M-estimator.}

\item{p}{An integer, at least 2.}
}
\value{
A real value. Returns the constant \eqn{\sigma_1} (cf. Vogel and Tyler 2014, p. 870, Example 2).
  This first appeared in Tyler (1982, p. 432, Example 3).
}
\description{
The asymptotic efficiency constant \eqn{\sigma_1} of the t-MLE for scatter
}
\details{
Let \eqn{X_1,...,X_n} be an i.i.d. sample from \eqn{t_{\nu,p}(\mu, S)}, i.e.,
a p-variate t-distribution with \eqn{\nu} degrees of freedom, location parameter \eqn{\mu}
and shape matrix \eqn{S}. The limit case \eqn{\nu = \infty} is allowed, where \eqn{t_{\infty,p}(\mu,S)} is
\eqn{N_p(\mu,S)}.
\cr
\cr
Let \eqn{\hat{S}_n} be the \eqn{t_m} MLE for scatter.
Also here, \eqn{m=\infty} is allowed: This is the sample covariance matrix.
If \eqn{\hat{S}_n} is applied to \eqn{X_1,...,X_n}, then, as \eqn{n \to \infty},
\eqn{\hat{S}_n} converges in probability to \eqn{\eta S}.
The function \code{find_sigma1()} returns a scalar appearing in the asymptotic
covariance matrix of \eqn{\hat{S}_n}.
\cr
\cr
The scalar  \eqn{\sigma_1} is defined as 
\deqn{ \sigma_1  =  \frac{(p+2)^2 \gamma_1}{(2\gamma_2 + p)^2}, } 
where
\deqn{\gamma_1 = \frac{E\{\phi^2(R/\eta)\}}{p(p+2)} \quad \mbox{ and } \quad
\gamma_2 = \frac{1}{p} E\left\{\frac{R}{\eta}\phi'\left(\frac{R}{\eta}\right)\right\},}
furthermore
\eqn{\phi(y) = y(m+p)/(m+y)} and \eqn{R = (X - \mu)^\top S^{-1} (X-\mu)} for
\eqn{X \sim t_{\nu,p}(\mu,S)}, and \eqn{\eta} is defined in the help page of 
\code{\link{find_eta}}.
\cr
\cr
A noteworthy difference between \code{find_sigma1} and
\code{\link[robFitConGraph]{find_eta}} is that the argument \code{df_est} may be
\code{0} for \code{find_sigma1}, but must strictly positive for \code{find_eta}.
For both functions, \code{df_data} must be strictly positive. There is no such thing
as a t-distribution with zero degrees of freedom. There is such a thing as a
t-MLE with zero degrees of freedom: the Tyler estimator. Its \eqn{\sigma_1} value is
\eqn{1 + 2/p} regardless of the underlying elliptical distribution. However, since
the Tyler estimator provides shape information only, but none on scale,
\eqn{\eta} is irrelevant in this case.
}
\examples{
find_sigma1(df_data = Inf, df_est = 3,   p = 10)
find_sigma1(df_data = 4.5, df_est = 4.5, p = 2)

}
\references{
Vogel, D., Tyler, D. E. (2014): Robust estimators
  for nondecomposable elliptical graphical models, \emph{Biometrika}, 101, 865-882
  \cr\cr
  Tyler, D. E. (1982): Radial estimates and the test for sphericity,
  \emph{Biometrika}, 69, 2, pp. 429-36
}
\author{
Daniel Vogel
}
