% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daCoDa.R
\name{daCoDa}
\alias{daCoDa}
\title{Linear and quadratic discriminant analysis for compositional data.}
\usage{
daCoDa(x, grp, coda = TRUE, method = "classical", rule = "linear", ...)
}
\arguments{
\item{x}{a matrix or data frame containing the explanatory variables}

\item{grp}{grouping variable: a factor specifying the class for each
observation.}

\item{coda}{TRUE, when the underlying data are compositions.}

\item{method}{\dQuote{classical} or \dQuote{robust}}

\item{rule}{a character, either \dQuote{linear} (the default) or \dQuote{quadratic}.}

\item{...}{additional arguments for the functions passed through}
}
\value{
An S4 object of class LdaClassic, Linda, QdaClassic or QdaCov. See package 
rrcov for details.
}
\description{
Linear and quadratic discriminant analysis for compositional data using either robust or 
classical estimation.
}
\details{
Compositional data are expressed in orthonormal (ilr) coordinates (if \code{coda==TRUE}). For linear 
discriminant analysis the functions LdaClassic (classical) and Linda (robust) from the 
package rrcov are used. Similarly, quadratic discriminant analysis 
uses the functions QdaClassic and QdaCov (robust) from the same package.

The classical linear and quadratic discriminant rules are invariant to ilr coordinates and clr
coefficients. The robust rules are invariant to ilr transformations if
affine equivariant robust estimators of location and covariance are taken.
}
\examples{
## toy data (non-compositional)
require(MASS)
x1 <- mvrnorm(20,c(0,0,0),diag(3))
x2 <- mvrnorm(30,c(3,0,0),diag(3))
x3 <- mvrnorm(40,c(0,3,0),diag(3))
X <- rbind(x1,x2,x3)
grp=c(rep(1,20),rep(2,30),rep(3,40))

clas1 <- daCoDa(X, grp, coda=FALSE, method = "classical", rule="linear")
summary(clas1)
## predict runs only with newest verison of rrcov
\dontrun{
predict(clas1)
}
# specify different prior probabilities
clas2 <- daCoDa(X, grp, coda=FALSE, prior=c(1/3, 1/3, 1/3))
summary(clas2)

## compositional data
data(coffee)
x <- coffee[coffee$sort!="robusta",2:7]
group <- droplevels(coffee$sort[coffee$sort!="robusta"])
cof.cla <- daCoDa(x, group, method="classical", rule="quadratic")
cof.rob <- daCoDa(x, group, method="robust", rule="quadratic")
## predict runs only with newest verison of rrcov
\dontrun{
predict(cof.cla)@ct
predict(cof.rob)@ct
}
}
\references{
Filzmoser, P., Hron, K., Templ, M. (2012) 
Discriminant analysis for compositional data and robust parameter estimation. 
\emph{Computational Statistics}, 27(4), 585-604.
}
\seealso{
\code{\link[rrcov]{LdaClassic}}, \code{\link[rrcov]{Linda}}, 
\code{\link[rrcov]{QdaClassic}}, \code{\link[rrcov]{QdaCov}}
}
\author{
Jutta Gamper
}
\keyword{multivariate}
