% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustCoDa_qmode.R
\name{clustCoDa_qmode}
\alias{clustCoDa_qmode}
\alias{plot.clustCoDa_qmode}
\title{Q-mode cluster analysis for compositional parts}
\usage{
clustCoDa_qmode(x, method = "ward.D2")
}
\arguments{
\item{x}{compositional data represented as a data.frame}

\item{method}{hclust method}
}
\value{
a hclust object
}
\description{
Clustering in using the variation matrix of compositional parts
}
\examples{
data(expenditures) 
x <- expenditures
cl <- clustCoDa_qmode(x)
plot(cl)
cl2 <- clustCoDa_qmode(x, method = "single")
plot(cl2)
}
\references{
Filzmoser, Hron, Templ
\emph{Applied Compositional Data Analysis}, 
Springer-Verlag, upcoming book.
}
\author{
Matthias Templ (accessing the basic features of hclust that 
are all written by other authors)
}
\keyword{multivariate}
