% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{append_fData}
\alias{append_fData}
\title{Append two compatible univariate functional datasets}
\usage{
append_fData(fD1, fD2)
}
\arguments{
\item{fD1}{is the first functional dataset, stored into an \code{fData} object.}

\item{fD2}{is the second functional dataset, stored into an \code{fData} object.}
}
\value{
The function returns an \code{fData} object containing the union of \code{fD1} and \code{fD2}
}
\description{
This is a convenience function that simplifies the task of appending univariate
functional observations of two datasets to a unique univariate functional dataset.
}
\details{
The two original datasets must be compatible, i.e. must be defined on the same grid.
If we denote with \eqn{X_1, \ldots, X_n} the first dataset, defined over the
grid \eqn{I = t_1, \ldots, t_P}, and with \eqn{Y_1, \ldots, Y_m} the second functional dataset,
defined on the same grid, the method returns the union dataset obtained by taking all the
\eqn{n + m} observations together.
}
\examples{
# Creating two simple univariate datasets

grid = seq(0, 2 * pi, length.out = 100)

values1 = matrix( c(sin(grid),
                    sin(2 * grid)), nrow = 2, ncol = length(grid),
                   byrow=TRUE)

values2 = matrix( c(cos(grid),
                    cos(2 * grid)), nrow = 2, ncol = length(grid),
                   byrow=TRUE)

fD1 = fData( grid, values1 )
fD2 = fData( grid, values2 )

# Appending them to a unique dataset
append_fData(fD1, fD2)

}
\seealso{
\code{\link{append_mfData}}, \code{\link{fData}}
}
