% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightFunctions.R
\name{gradePenaltyFn}
\alias{gradePenaltyFn}
\title{Grade penalty edge weight function}
\usage{
gradePenaltyFn(
  x1,
  x2,
  hdistance,
  baseCost = 16178,
  limit = 20,
  penalty = 504,
  limitWeight = NA
)
}
\arguments{
\item{x1, x2}{Number. Value of the input raster at two nodes.}

\item{hdistance}{Number. Horizontal distance between nodes. \code{hdistance}, \code{x1}, and \code{x2}
should have the same units.}

\item{baseCost}{Number. Construction cost of 0\% grade road per km.}

\item{limit}{Number. Maximum grade (\%) on which roads can be built.}

\item{penalty}{Number. Cost increase (per km) associated with each
additional \% increase in road grade.}

\item{limitWeight}{Number. Value assigned to edges that exceed the grade
limit. Try setting to a high (not \code{NA}) value if encountering problems with
disconnected graphs.}
}
\description{
Method for calculating the weight of an edge between two nodes from the value
of the input raster at each of those nodes (\code{x1} and \code{x2}), designed for a single
DEM input. The method assumes an input \code{weightRaster} in which:
\itemize{
\item \code{NA} indicates a road cannot be built
\item Negative values are costs for crossing streams or other barriers that are
crossable but expensive. Edges that link to barrier penalty (negative value)
nodes are assigned the largest barrier penalty weight.
\item Zero values are assumed to be existing roads.
\item All other values are interpreted as elevation in the units of the raster
map (so that a difference between two cells equal to the map resolution can be
interpreted as 100\% grade)
This is a simplified version of the grade penalty approach taken by Anderson and Nelson (2004):
The approach does not distinguish between adverse and favourable grades.
Default construction cost values are from the BC interior appraisal manual.
The approach ignores (unknown) grade penalties beside roads and barriers in order to
avoid increased memory and computational burden associated with multiple input rasters.
}
}
\examples{
gradePenaltyFn(0.5,0.51,1)
gradePenaltyFn(0.5,0.65,1)
# grade > 20\% so NA
gradePenaltyFn(0.5,0.75,1)
}
\references{
Anderson AE, Nelson J (2004) Projecting vector-based road networks with a
shortest path algorithm. Canadian Journal of Forest Research 34:1444–1457. https://doi.org/10.1139/x04-030
}
