% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSG2LatLon.R
\name{OSG2LatLon}
\alias{OSG2LatLon}
\title{Converts easting/northing to latitude/longitude.}
\usage{
OSG2LatLon(en)
}
\arguments{
\item{en}{this is a vector containing the easting and northing coordinates.}
}
\value{
vector made of two elements: the latitude and longitude.
}
\description{
This function converts easting and northing coordinates (UK National Grid, epsg:27700) and converts them to longitute and latitude (WGS84, epsg:4326). It uses rgadal and sp functionalities for coordinates transformations.
}
\examples{
# single entry
OSG2LatLon(c(572200,121300))

# use result from OSGParse() function
OSG2LatLon(OSGParse("TQ722213"))

# multiple entries & use result from OSGParse() function
OSG2LatLon(OSGParse(c("SN831869","SN829838","SN824853","SN824842","SN826854")))
}
\author{
Claudia Vitolo
}
\references{
This function is based on the following forum post: https://stat.ethz.ch/pipermail/r-sig-geo/2010-November/010141.htm
}

