% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\name{argo}
\alias{argo}
\alias{argo_search}
\alias{argo_files}
\alias{argo_qwmo}
\alias{argo_plan}
\alias{argo_buoy_files}
\title{Get Argo buoy data}
\usage{
argo_search(func = NULL, of = NULL, qwmo = NULL, wmo = NULL,
  box = NULL, area = NULL, around = NULL, year = NULL,
  yearmin = NULL, yearmax = NULL, month = NULL, monthmin = NULL,
  monthmax = NULL, lr = NULL, from = NULL, to = NULL,
  dmode = NULL, pres_qc = NULL, temp_qc = NULL, psal_qc = NULL,
  doxy_qc = NULL, ticket = NULL, limit = 10, ...)

argo_files(wmo = NULL, cyc = NULL, ...)

argo_qwmo(qwmo, limit = 10, ...)

argo_plan(...)

argo_buoy_files(dac, id, ...)

argo(dac, id, cycle, dtype, ...)
}
\arguments{
\item{func}{A function, one of n, np, nf, coord, fullcoord, list, ftplist, ticket, version}

\item{of}{of string}

\item{qwmo}{qwmo string}

\item{wmo}{wmo string. mandatory when using \code{argo_files}}

\item{box}{Bounding box, of the form: A) lon, lat for geographical coordinates of
the center of a box, or B) min lon, min lat, width, height, for geographical
coordinates of the center of the box and its width and height, and the longitude must
given between -180W and 180E. Width and height are in degrees of longitude and latitude.}

\item{area}{(integer/character), One of 0, 1, or 2, but can be in combination. e.g. 0, '0,2'
See Details.}

\item{around}{(character) Selects profiles located around a given center point. List of
3 or 4 numerical values depending on how the center point need to be specified:
e.g., '-40,35,100', '6900678,2,200', '6900678,2,200,30'. See Details}

\item{year}{restrict profiles sampled on a single, or a list of given years. One or a
comma separated list of numerical value(s) higher than 0 and lower than 9999.}

\item{yearmin, yearmax}{restrict profiles sampled before (yearmax) and/or after (yearmin)
a given year. A numerical value higher than 0 and lower than 9999. cannot be applied with
the other restriction parameter \code{year}}

\item{month}{restrict profiles sampled on a single, or a list of given month(s). One or a
comma separated list of numerical value(s) higher or equal to 1 and lower or equal to 12.
The month convention is a standard one: January is 1, February is 2, ... December is 12.}

\item{monthmin, monthmax}{restrict profiles sampled before (monthmax) and/or after (monthmin)
a given month. Higher or equal to 1 and lower or equal to 12. The month convention is a
standard one: January is 1, February is 2, ... December is 12. These restrictions cannot be
applied with the other restriction parameter month. At this time, these parameters are not
circular, so that the restriction chain: monthmin=12&monthmax=2 will through an error
and not select December to February profiles. To do so, you need to use a coma separated
list of months using the month restriction parameter.}

\item{lr}{restriction allows you to impose the last report (hence lr) date in days. A
numerical value in days between 1 (profiles sampled yesterday) and 60 (profiles sampled
over the last 60 days). This restriction allows a simple selection of the so-called
'active' floats, ie those which reported a profiles over the last 30 days.}

\item{from, to}{select profiles sampled before (to) and/or after (from) an explicit date
(included). The date is specified following the format: YYYYMMDD, ie the year, month
and day numbers.}

\item{dmode}{(character) imposes a restriction on the Data Mode of profiles. A single value or
a coma separated list of characters defining the Data Mode to select. It can be: R for
"Real Time", A for "Real Time with Adjusted value" and D for "Delayed Mode". See Details.}

\item{pres_qc, temp_qc, psal_qc, doxy_qc}{Quality control. Imposes a restriction on the profile
data quality flag. For a given variable <PARAM> which can be: pres (pressure),
temp (temperature), psal (salinity) or doxy (oxygen), this restriction selects profiles
having one or a coma separated list of data quality flag. See Details.}

\item{ticket}{(numeric) select profiles with or without a ticket filled in the database. A
value: 0 (no ticket) or 1 (has a ticket). See
http://www.ifremer.fr/lpo/naarc/m/docs/api/database.html for more details.}

\item{limit}{(integer) number to return}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}. Optional}

\item{cyc}{a cycle number}

\item{dac}{(character) Data assembly center code}

\item{id}{(numeric) Buoy identifier}

\item{cycle}{(numeric) Cycle number}

\item{dtype}{(character) Data type, one of \code{D} for delayed, or \code{R} for real-time}
}
\description{
THE ARGO API IS DOWN. WE'VE BEEN UNSUCCESSFUL FIGURING OUT WHERE
THE API MOVED TO OR IF IT STILL EXISTS. SEE "API Status" SECTION
BELOW FOR MORE DETAILS.
}
\details{
\code{area} parameter definitions:
\itemize{
\item Value 0 selects profiles located in the North-Atlantic ocean north of 20S
and not in areas 1 and 2.
\item Value 1 selects profiles located in the Mediterranean Sea.
\item Value 2 selects profiles located in the Nordic Seas.
}

\code{around} parameter definitions:
\itemize{
\item Specification 1: The location is specified with specific geographical
coordinates in the following format: around=longitude,latitude,distance - The longitude
must given between -180W and 180E and the distance is in kilometers.
\item Specification 2: The location is the one of an existing profile in the database.
It is thus specified with a float WMO and a cycle number: around=wmo,cyc,distance
This specification can take an optional fourth value specifying the time range in days
around the specified profile.
}

\code{dmode} parameter definitions:
\itemize{
\item Data from Argo floats are transmitted from the float, passed through processing and
automatic quality control procedures. These profiles have a Data Mode called: real-time data.
\item The data are also issued to the Principle Investigators who apply other procedures to
check data quality returned to the global data centre within 6 to 12 months. These profiles
have a Data Mode called: delayed mode data.
\item The adjustments applied to delayed-data may also be applied to real-time data, to
correct sensor drifts for real-time users. These profiles have a Data Mode called: real
time data with adjusted values.
}

\code{*_qc} parameter definitions:
This information was extracted from the netcdf profile variable PROFILE_<PARAM>_QC. Once
quality control procedures have been applied, a synthetic flag is assigned for each
parameter of each profile under this variable in netcdf files. It indicates the fraction
n of profile levels with good data. It can take one of the following values:
\itemize{
\item A or F: All (n=100%) or none (n=0%) of the profile levels contain good data,
\item B,C,D,E: n is in one of the intermediate range: 75-100, 50-75, 25-50 or 0-25
\item empty: No QC was performed.
}
}
\section{File storage}{

We use \pkg{rappdirs} to store files, see
\code{\link[rappdirs]{user_cache_dir}} for how we determine the directory on
your machine to save files to, and run
\code{rappdirs::user_cache_dir("rnoaa/argo")} to get that directory.

The \code{path} parameter used to be used to set where files are stored
on your machine.
}

\section{API Status}{

The API is down as of 2019-11-07, and probably some time before that. The
following functions won't work anymore (future package versions may bring
them back if the API comes back):

\itemize{
\item argo_search
\item argo_files
\item argo_qwmo
\item argo_plan
}

The following functions still work as they are based off the FTP server
that still exists:

\itemize{
\item argo_buoy_files
\item argo
}
}

\examples{
\dontrun{
# Search Argo metadata
## Number of profiles
# argo_search("np", limit = 3)
## Number of floats
# argo_search("nf", limit = 3)
## Number of both profiles and floats
# argo_search("n", limit = 3)
## return the coordinates in time and space of profiles
# argo_search("coord", limit = 3)
## return the coordinates in time and space of profiles, plus other metadata
# argo_search("fullcoord", limit = 3)

## List various things, e.g,...
### data assembly centers
# argo_search("list", "dac")
### data modes
# argo_search("list", "dmode", limit = 5)
### World Meteorological Organization unique float ID's
# argo_search("list", "wmo", limit = 5)
### Profile years
# argo_search("list", "year", limit = 5)

## coord or fullcoord with specific buoy id
# argo_search("coord", wmo = 13857, limit = 3)
# argo_search("fullcoord", wmo = 13857, limit = 3)

# Spatial search
### search by bounding box (see param def above)
# argo_search("coord", box = c(-40, 35, 3, 2))
### search by area
# argo_search("coord", area = 0)
### search by around
# argo_search("coord", around = '-40,35,100')

# Time based search
### search by year
# argo_search("coord", year = 2006)
### search by yearmin and yearmax
# argo_search("coord", yearmin = 2007)
# argo_search("coord", yearmin = 2007, yearmax = 2009)
### search by month
# argo_search("coord", month = '12,1,2')
### search by from or to
# argo_search("coord", from = 20090212)
# argo_search("coord", to = 20051129)

# Data mode search
# argo_search("coord", dmode = "R")
# argo_search("coord", dmode = "R,A")

# Data quality based search
# argo_search("coord", pres_qc = "A,B")
# argo_search("coord", temp_qc = "A")
# argo_search("coord", pres_qc = "A", temp_qc = "A")

# Ticket search
# argo_search("coord", ticket = 0)

## Search on partial float id number
# argo_qwmo(qwmo = 49)
# argo_qwmo(qwmo = 49, limit = 2)

## Get files
# argo_files(wmo = 13857)
# argo_files(wmo = 13857, cyc = 12)
# argo_files(wmo = 13857, cyc = 45)

## Get planned buoys data, accepts no parameters
# argo_plan()

# Get files for a buoy, must specify data assembly center (dac)
argo_buoy_files(dac = "bodc", id = 1901309)
argo_buoy_files(dac = "kma", id = 2900308)

# Get data
x <- argo_buoy_files(dac = "meds", id = 4900881)
argo(dac = "meds", id = 4900881, cycle = 127, dtype = "D")
}
}
\references{
http://www.ifremer.fr/lpo/naarc/m/docs/api/howto.html
}
