% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_tables.R
\name{get_todays_exchangerate_table}
\alias{get_todays_exchangerate_table}
\title{Retrieves the exchange rate table that was published today.}
\usage{
get_todays_exchangerate_table(table)
}
\arguments{
\item{table}{specifies which table should be fetched.}
}
\value{
nbp_api_response object containing today's exchange rate table.
}
\description{
Retrieves the exchange rate table that was published today.
}
\details{
If today's data is not available the API will
return a 404 Not found error. In that case the function will
return an error with an appropriate message.
}
\examples{

\donttest{
## Fetch todays A exchange rate table
response <- get_todays_exchangerate_table("A")

## Preview response content
response$content
}

}
\seealso{
\url{https://api.nbp.pl/#kursyWalut}

Other tables: 
\code{\link{get_current_exchangerate_table}()},
\code{\link{get_exchangerate_table_from}()},
\code{\link{get_exchangerate_tables_from_interval}()},
\code{\link{get_last_n_exchangerate_tables}()}
}
\concept{tables}
