#' Recreation data from Value of Nature to Canadians Survey
#'
#' Data from 997 individuals from the Value of Nature to Canadians (VNC) survey.
#' The travel costs are calculated using the approach described in Lloyd-Smith (2019)
#'
#' @docType data
#'
#' @usage data(data_rec)
#' @format A tibble with 16949 rows and 9 variables
#' @keywords datasets
#' @references Federal, Provincial, and Territorial Governments of Canada. 2014.
#' “2012 Canadian Nature Survey: Awareness, Participation, and Expenditures in Nature-Based Recreation, Conservation, and Subsistence Activities.” Ottawa, ON: Canadian Councils of Resource Ministers.
#' (\href{http://publications.gc.ca/site/eng/9.698872/publication.html}{PubMed})
#'
#' @references Lloyd-Smith, P (2019).
#' “The Economic Benefits of Outdoor Recreation in Canada”. Working Paper
#'
#' @source \href{http://donnees.ec.gc.ca/data/managementoversight/systems/canadian-nature-survey-2012/}{Canadian Nature Survey 2012}
"data_rec"
