% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmcorr.R
\name{rmcorr}
\alias{rmcorr}
\title{Calculate the repeated measures correlation coefficient.}
\usage{
rmcorr(
  participant,
  measure1,
  measure2,
  dataset,
  CI.level = 0.95,
  CIs = c("analytic", "bootstrap"),
  nreps = 100,
  bstrap.out = F
)
}
\arguments{
\item{participant}{A variable giving the subject name/id for each observation.}

\item{measure1}{A numeric variable giving the observations for one measure.}

\item{measure2}{A numeric variable giving the observations for the second measure.}

\item{dataset}{The data frame containing the variables.}

\item{CI.level}{The confidence level of the interval}

\item{CIs}{The method of calculating confidence intervals.}

\item{nreps}{The number of resamples to take if bootstrapping.}

\item{bstrap.out}{Determines if the output include the bootstrap resamples.}
}
\value{
A list with class "rmc" containing the following components.
\item{r}{the value of the repeated measures correlation coefficient.}
\item{df}{the degrees of freedom}
\item{p}{the p-value for the repeated measures correlation coefficient.}
\item{CI}{the 95\% confidence interval for the repeated measures correlation coefficient.}
\item{model}{the multiple regression model used to calculate the correlation coefficient.}
\item{resamples}{the bootstrap resampled correlation values.}
}
\description{
Calculate the repeated measures correlation coefficient.
}
\examples{
## Bland Altman 1995 data
rmcorr(Subject, PacO2, pH, bland1995)
}
\references{
Bakdash, J.Z., & Marusich, L.R. (2017). 
Repeated Measures Correlation. \emph{Frontiers in Psychology, 8}, 256. 
\url{https://doi.org/10.3389/fpsyg.2017.00456}.

Bland, J.M., & Altman, D.G. (1995). Calculating correlation 
coefficients with repeated observations: Part 1 - correlation within
subjects. \emph{BMJ, 310}, 446.
}
\seealso{
\code{\link{plot.rmc}}
}
