% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context_document.R
\name{context_document}
\alias{context_document}
\title{Convert to a ConTeXt document}
\usage{
context_document(
  toc = FALSE,
  toc_depth = 2,
  number_sections = FALSE,
  fig_width = 6.5,
  fig_height = 4.5,
  fig_crop = TRUE,
  fig_caption = TRUE,
  dev = "pdf",
  df_print = "default",
  template = NULL,
  keep_tex = FALSE,
  keep_md = FALSE,
  citation_package = c("none", "natbib", "biblatex"),
  includes = NULL,
  md_extensions = NULL,
  output_extensions = NULL,
  pandoc_args = NULL,
  context_path = NULL,
  context_args = NULL,
  ext = c(".pdf", ".tex")
)
}
\arguments{
\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_depth}{Depth of headers to include in table of contents}

\item{number_sections}{\code{TRUE} to number section headings}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_crop}{\code{TRUE} to automatically apply the \code{pdfcrop} utility
(if available) to pdf figures}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{dev}{Graphics device to use for figure output (defaults to pdf)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses \code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}.}

\item{template}{Pandoc template to use for rendering. Pass "default" to use
the rmarkdown package default template; pass \code{NULL} to use pandoc's
built-in template; pass a path to use a custom template that you've
created.  See the documentation on
\href{http://pandoc.org/README.html}{pandoc online documentation}
for details on creating custom templates.}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{citation_package}{The LaTeX package to process citations, \code{natbib}
or \code{biblatex}. Use \code{none} if neither package is to be used.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{output_extensions}{Pandoc extensions to be added or removed from the
output format, e.g., \code{"-smart"} means the output format will be
\code{latex-smart}.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{context_path}{Path of the ConTeXt executable. If not provided, ConTeXt has
to be available from the \code{PATH} environment variable.}

\item{context_args}{Command line arguments passed to ConTeXt.}

\item{ext}{Format of the output document (defaults to ".pdf").}
}
\value{
R Markdown output format to pass to \code{\link{render}}.
}
\description{
Format for converting from R Markdown to PDF using
\href{https://wiki.contextgarden.net/}{ConTeXt}.
}
\details{
ConTeXt needs to be installed. To install the most recent version, see
\url{https://wiki.contextgarden.net/Installation}. A less recent version is
also available in TeX Live, you can install it with
\code{tinytex::tlmgr_install("context")}.

R Markdown documents can have optional metadata that is used to generate a
document header that includes the title, author, and date. For more details
see the documentation on R Markdown \link[=rmd_metadata]{metadata}.

R Markdown documents also support citations. You can find more information on
the markdown syntax for citations in the
\href{https://rmarkdown.rstudio.com/authoring_bibliographies_and_citations.html}{Bibliographies
and Citations} article in the online documentation.
}
\examples{
\dontrun{
library(rmarkdown)

# simple invocation
render("input.Rmd", context_document())
}
}
