% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explode.R
\name{ms_explode}
\alias{ms_explode}
\title{Convert multipart lines or polygons to singlepart}
\usage{
ms_explode(input, force_FC = TRUE, sys = FALSE)
}
\arguments{
\item{input}{One of:
\itemize{
\item \code{geo_json} or \code{character} multipart lines, or polygons;
\item \code{geo_list} multipart lines, or polygons;
\item multipart \code{SpatialPolygons}, \code{SpatialLines};
\item \code{sf} or \code{sfc} multipart lines, or polygons object
}}

\item{force_FC}{should the output be forced to be a \code{FeatureCollection} even
if there are no attributes? Default \code{TRUE}.
\code{FeatureCollections} are more compatible with \code{rgdal::readOGR} and
\code{geojsonio::geojson_sp}. If \code{FALSE} and there are no attributes associated with
the geometries, a \code{GeometryCollection} will be output. Ignored for \code{Spatial}
objects, as the output is always the same class as the input.}

\item{sys}{Should the system mapshaper be used instead of the bundled mapshaper? Gives
better performance on large files. Requires the mapshaper node package to be installed
and on the PATH.}
}
\value{
same class as input
}
\description{
For objects of class \code{Spatial} (e.g., \code{SpatialPolygonsDataFrame}),
you may find it faster to use \code{sp::disaggregate}.
}
\details{
There is currently no method for SpatialMultiPoints
}
\examples{
library(geojsonio)
library(sp)

poly <- structure("{\"type\":\"FeatureCollection\",\"crs\":
          {\"type\":\"name\",\"properties\":{\"name\":
          \"urn:ogc:def:crs:OGC:1.3:CRS84\"}},\"features\":
          [\n{\"type\":\"Feature\",\"geometry\":{\"type\":
          \"MultiPolygon\",\"coordinates\":[[[[102,2],[102,3],
          [103,3],[103,2],[102,2]]],[[[100,0],[100,1],[101,1],
          [101,0],[100,0]]]]},\"properties\":{\"rmapshaperid\":0}}\n]}",
          class = c("json", "geo_json"))

poly <- geojson_sp(poly)
plot(poly)
length(poly)
poly@data

# Explode the polygon
out <- ms_explode(poly)
plot(out)
length(out)
out@data

}
