% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_nodes.R
\name{search_nodes}
\alias{search_nodes}
\title{Query nodes}
\usage{
search_nodes(query, verbose = TRUE, ...)
}
\arguments{
\item{query}{either a character string including a single keyword or a list containing a custom query (see details section below).
Note that if an empty character string is passed, then all datasets available are returned.}

\item{verbose}{a \code{logical}. Should extra information be reported on progress?}

\item{...}{further arguments to be passed to \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
An object of class \code{mgSearchNodes}, which is a \code{data.frame} including taxa #' matching the query and corresponding information.
All networks in which taxa are involved are also attached to the \code{data.frame}.
}
\description{
Search for networks by querying the nodes table.
If the \code{query} is a character string, then all character columns in the table
are searched and the entries for which at least one
partial match was found are returned.
Alternatively, a named list can be used to look for an exact match in a specific column (see Details section)
}
\details{
Names of the list should match one of the column names within the table.
For the \code{networks} table, those are:
\itemize{
\item id: unique identifier of the nodes;
\item original_name: taxonomic name as in the original publication;
\item node_level: either population, taxon or individual;
\item network_id: Mangal network identifier.
}

Note that for lists with more than one element, only the first element is used, the others are ignored. An example is provided below.
}
\examples{
res_acer <- search_nodes("Acer")
res_926 <- search_nodes(list(network_id = 926))

}
\references{
Metadata available at \url{https://mangal-wg.github.io/mangal-api/#nodes}
}
\seealso{
\code{\link[=search_taxonomy]{search_taxonomy()}}
}
