% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdownRule.R
\name{markdownRule}
\alias{markdownRule}
\title{Rule for building text documents from Markdown files}
\usage{
markdownRule(target, script, depends = NULL, format = "all",
  params = NULL, task = "all")
}
\arguments{
\item{target}{Name of the output file to be created}

\item{script}{Name of the markdown file to be rendered}

\item{depends}{A vector of file names that the markdown script depends on, or \code{NULL}.}

\item{format}{Requested format of the result. Parameter is passed as \code{format} argument
to \code{\link[rmarkdown:render]{rmarkdown::render()}}. Allowed values are: 'all', 'html_document', 'pdf_document',
'word_document', 'odt_document', 'rtf_document', or 'md_document'.}

\item{params}{\code{NULL} or a list of R values that become available within the \code{script} in
a \code{params} variable.}

\item{task}{A character vector of parent task names. The mechanism of tasks allows to
group rules. Anything different from \code{'all'} will
cause creation of a new task depending on the given rule. Executing \code{make taskname}
will then force building of this rule.}
}
\value{
Instance of S3 class \code{rmake.rule}
}
\description{
This rule is for execution of Markdown rendering in order to create text file
of various supported formats such as (PDF, DOCX, etc.).
}
\details{
This rule executes the following command in a separate R process:
`params <- params; rmarkdown::render(script, output_format=format, output_file=target)``

Issuing \code{make clean} from the shell causes removal of all files specified in \code{target} parameter.
}
\examples{
r <- markdownRule(target='report.pdf',
                  script='report.Rmd',
                  depends=c('data1.csv', 'data2.csv'))

# generate the content of a makefile (as character vector)
makefile(list(r))

# generate to file
tmp <- tempdir()
makefile(list(r), file.path(tmp, "Makefile"))
}
\seealso{
\code{\link[=rule]{rule()}}, \code{\link[=makefile]{makefile()}}, \code{\link[=rRule]{rRule()}}
}
\author{
Michal Burda
}
