% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pauc_out.R
\name{pauc_out}
\alias{pauc_out}
\title{Evaluation of  Differential Expression Analysis Methods}
\usage{
pauc_out(p, EE, DE)
}
\arguments{
\item{p}{a vector of p-values.}

\item{EE}{number of EE genes (the first EE genes in p-value vector p).}

\item{DE}{number of DE genes (the last DE genes in p-value vector p).}
}
\value{
a vector including  V (the
 number of false positives), R (the number of declared positives), FDR (the
 false discovery rate), pauc (the partial area under ROC curve with respect
 to false positive rate fpr less than or equal to a specified level), and
 auc.
 Here we consider 3 fpr: 0.05, 0.10, 0.20. So the output includes these 15 elements
 and the total auc.
}
\description{
This function calculates FDR (false discovery rate), pauc (partial area
under ROC curve),  when we know the vector of
p-values obtained from a particular differential expression analysis method and the
true status of each gene. The function requires that the first EE genes are
true EE, and the last DE genes are true DE. This requirement can be fulfilled
by reorder the rows of gene expression data set.
}
\examples{
set.seed(1)
EE <- 1000
DE <- 500
p1 <- runif(EE)
p2 <- rbeta(DE, shape1 = .5, shape2 = 1)
p <- c(p1, p2)
rmRNAseq:::pauc_out(p, EE, DE)
}
