% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{load.NuggetKriging}
\alias{load.NuggetKriging}
\title{Load a NuggetKriging Model from a file storage}
\usage{
load.NuggetKriging(filename, ...)
}
\arguments{
\item{filename}{File name to load from.}

\item{...}{Not used.}
}
\value{
The loaded NuggetKriging object.
}
\description{
Load a NuggetKriging Model from a file storage
}
\examples{
f <- function(x) 1- 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x)*x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))
points(X, y, col = "blue")

k <- NuggetKriging(y, X, "matern3_2")
print(k)

outfile = tempfile("k.h5")
save(k,outfile)

print(load.NuggetKriging(outfile)) 
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
