% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/runners.R
\name{GrossoLocatelliPullanMcRunner}
\alias{GrossoLocatelliPullanMcRunner}
\alias{getBipartitePartitionsRunner}
\alias{getAndCheckTopologicalSortRunner}
\alias{getTopologicalSortRunner}
\alias{IsConnectedRunner}
\alias{IsAcyclicRunner}
\alias{IsTreeRunner}
\alias{IsBipartiteRunner}
\alias{IsStronglyConnectedRunner}
\alias{IsDAGRunner}
\alias{IsBiNodeConnectedRunner}
\alias{IsBiEdgeConnectedRunner}
\alias{IsLoopFreeRunner}
\alias{IsParallelFreeRunner}
\alias{IsSimpleGraphRunner}
\alias{IsEulerianRunner}
\alias{CountBiEdgeConnectedComponentsRunner}
\alias{CountConnectedComponentsRunner}
\alias{CountBiNodeConnectedComponentsRunner}
\alias{CountStronglyConnectedComponentsRunner}
\alias{FindStronglyConnectedComponentsRunner}
\alias{FindStronglyConnectedCutArcsRunner}
\alias{FindBiEdgeConnectedCutEdgesRunner}
\alias{FindBiNodeConnectedComponentsRunner}
\alias{FindBiNodeConnectedCutNodesRunner}
\alias{FindConnectedComponentsRunner}
\alias{FindBiEdgeConnectedComponentsRunner}
\alias{GraphCompatabilityConverter}
\alias{BfsRunner}
\alias{DfsRunner}
\alias{MaxCardinalitySearchRunner}
\alias{CirculationRunner}
\alias{PreflowRunner}
\alias{EdmondsKarpRunner}
\alias{MaximumWeightPerfectMatchingRunner}
\alias{MaximumWeightFractionalPerfectMatchingRunner}
\alias{MaximumWeightFractionalMatchingRunner}
\alias{MaximumWeightMatchingRunner}
\alias{MaximumCardinalityMatchingRunner}
\alias{MaximumCardinalityFractionalMatchingRunner}
\alias{CycleCancellingRunner}
\alias{CapacityScalingRunner}
\alias{CostScalingRunner}
\alias{NetworkSimplexRunner}
\alias{NagamochiIbarakiRunner}
\alias{HaoOrlinRunner}
\alias{GomoryHuTreeRunner}
\alias{HowardMmcRunner}
\alias{KarpMmcRunner}
\alias{HartmannOrlinMmcRunner}
\alias{KruskalRunner}
\alias{MinCostArborescenceRunner}
\alias{PlanarCheckingRunner}
\alias{PlanarEmbeddingRunner}
\alias{PlanarColoringRunner}
\alias{PlanarDrawingRunner}
\alias{SuurballeRunner}
\alias{DijkstraRunner}
\alias{BellmanFordRunner}
\alias{ChristofidesRunner}
\alias{GreedyTSPRunner}
\alias{InsertionTSPRunner}
\alias{NearestNeighborTSPRunner}
\alias{Opt2TSPRunner}
\alias{lemon_runners}
\title{LEMON runners}
\usage{
GrossoLocatelliPullanMcRunner(arcSources, arcTargets, numNodes)

getBipartitePartitionsRunner(arcSources, arcTargets, numNodes)

getAndCheckTopologicalSortRunner(arcSources, arcTargets, numNodes)

getTopologicalSortRunner(arcSources, arcTargets, numNodes)

IsConnectedRunner(arcSources, arcTargets, numNodes)

IsAcyclicRunner(arcSources, arcTargets, numNodes)

IsTreeRunner(arcSources, arcTargets, numNodes)

IsBipartiteRunner(arcSources, arcTargets, numNodes)

IsStronglyConnectedRunner(arcSources, arcTargets, numNodes)

IsDAGRunner(arcSources, arcTargets, numNodes)

IsBiNodeConnectedRunner(arcSources, arcTargets, numNodes)

IsBiEdgeConnectedRunner(arcSources, arcTargets, numNodes)

IsLoopFreeRunner(arcSources, arcTargets, numNodes)

IsParallelFreeRunner(arcSources, arcTargets, numNodes)

IsSimpleGraphRunner(arcSources, arcTargets, numNodes)

IsEulerianRunner(arcSources, arcTargets, numNodes)

CountBiEdgeConnectedComponentsRunner(arcSources, arcTargets, numNodes)

CountConnectedComponentsRunner(arcSources, arcTargets, numNodes)

CountBiNodeConnectedComponentsRunner(arcSources, arcTargets, numNodes)

CountStronglyConnectedComponentsRunner(arcSources, arcTargets, numNodes)

FindStronglyConnectedComponentsRunner(arcSources, arcTargets, numNodes)

FindStronglyConnectedCutArcsRunner(arcSources, arcTargets, numNodes)

FindBiEdgeConnectedCutEdgesRunner(arcSources, arcTargets, numNodes)

FindBiNodeConnectedComponentsRunner(arcSources, arcTargets, numNodes)

FindBiNodeConnectedCutNodesRunner(arcSources, arcTargets, numNodes)

FindConnectedComponentsRunner(arcSources, arcTargets, numNodes)

FindBiEdgeConnectedComponentsRunner(arcSources, arcTargets, numNodes)

GraphCompatabilityConverter(nodesList, arcSources, arcTargets)

BfsRunner(arcSources, arcTargets, numNodes, startNode = -1L, endNode = -1L)

DfsRunner(arcSources, arcTargets, numNodes, startNode = -1L, endNode = -1L)

MaxCardinalitySearchRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  numNodes,
  startNode = -1L
)

CirculationRunner(
  arcSources,
  arcTargets,
  arcLowerBound,
  arcUpperBound,
  nodeSupplies,
  numNodes
)

PreflowRunner(
  arcSources,
  arcTargets,
  arcDistances,
  sourceNode,
  destinationNode,
  numNodes
)

EdmondsKarpRunner(
  arcSources,
  arcTargets,
  arcDistances,
  sourceNode,
  destinationNode,
  numNodes
)

MaximumWeightPerfectMatchingRunner(
  arcSources,
  arcTargets,
  arcWeights,
  numNodes
)

MaximumWeightFractionalPerfectMatchingRunner(
  arcSources,
  arcTargets,
  arcWeights,
  numNodes
)

MaximumWeightFractionalMatchingRunner(
  arcSources,
  arcTargets,
  arcWeights,
  numNodes
)

MaximumWeightMatchingRunner(arcSources, arcTargets, arcWeights, numNodes)

MaximumCardinalityMatchingRunner(arcSources, arcTargets, numNodes)

MaximumCardinalityFractionalMatchingRunner(arcSources, arcTargets, numNodes)

CycleCancellingRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes
)

CapacityScalingRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes
)

CostScalingRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes
)

NetworkSimplexRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes
)

NagamochiIbarakiRunner(arcSources, arcTargets, arcWeights, numNodes)

HaoOrlinRunner(arcSources, arcTargets, arcWeights, numNodes)

GomoryHuTreeRunner(arcSources, arcTargets, arcWeights, numNodes)

HowardMmcRunner(arcSources, arcTargets, arcDistances, numNodes)

KarpMmcRunner(arcSources, arcTargets, arcDistances, numNodes)

HartmannOrlinMmcRunner(arcSources, arcTargets, arcDistances, numNodes)

KruskalRunner(arcSources, arcTargets, arcDistances, numNodes)

MinCostArborescenceRunner(
  arcSources,
  arcTargets,
  arcDistances,
  sourceNode,
  numNodes
)

PlanarCheckingRunner(arcSources, arcTargets, numNodes)

PlanarEmbeddingRunner(arcSources, arcTargets, numNodes)

PlanarColoringRunner(arcSources, arcTargets, numNodes, useFiveAlg = TRUE)

PlanarDrawingRunner(arcSources, arcTargets, numNodes)

SuurballeRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  startNode,
  endNode
)

DijkstraRunner(arcSources, arcTargets, arcDistances, numNodes, startNode)

BellmanFordRunner(arcSources, arcTargets, arcDistances, numNodes, startNode)

ChristofidesRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

GreedyTSPRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

InsertionTSPRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

NearestNeighborTSPRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

Opt2TSPRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

lemon_runners()
}
\arguments{
\item{arcSources}{a vector corresponding to the source nodes of a graph’s
edges}

\item{arcTargets}{a vector corresponding to the destination nodes of a
graph’s edges}

\item{numNodes}{the number of nodes in the graph}

\item{nodesList}{a vector of all the nodes in the graph}

\item{startNode}{in path-based algorithms, the start node of the path}

\item{endNode}{in path-based algorithms, the end node of the path}

\item{arcCapacities}{vector corresponding to the capacities of nodes of a
graph’s edges}

\item{arcLowerBound}{vector corresponding to the lower-bound capacities of
nodes of a graph’s edges}

\item{arcUpperBound}{vector corresponding to the upper-bound capacities of
nodes of a graph’s edges}

\item{nodeSupplies}{vector corresponding to the supplies of each node of the
graph}

\item{arcDistances}{vector corresponding to the distances of a graph’s edges}

\item{sourceNode}{in flow-based algorithms, the source node of the flow}

\item{destinationNode}{in flow-based algorithms, the destination node of the
flow}

\item{arcWeights}{vector corresponding to the weights of a graph’s arcs}

\item{arcCosts}{vector corresponding to the costs of nodes of a graph’s
edges}

\item{useFiveAlg}{if \code{TRUE} (default), run a 5-color algorithm. If
\code{FALSE}, runs a faster 6-coloring algorithm instead.}

\item{defaultEdgeWeight}{The default edge weight if an edge is not-specified
(default value 999999)}
}
\value{
Algorithm results
}
\description{
These "runner" functions provide a slightly lower-level access to LEMON.
}
\details{
Internally, all exported rlemon functions call a "runner" function to
interface with the C++, for example, \code{MaxFlow(..., algorithm =
"PreFlow")} will call \code{PreFlowRunner(...)}.

In almost all cases, users will want to stick with the exported functions.

Runners differ from exported functions in two significant way and one
minor way:
\enumerate{
 \item Exported functions provide input checking.
 \item Exported functions provide slightly cleaner output, such as
       converting 0/1 boolean into \code{logical}.
 \item The \code{arcWeights} argument is optional to \code{MaxMatching()},
       automatically generating a constant weight if it is excluded.
       \code{arcWeights} is not optional in \code{MaxMatchingRunner()}.
}
}
