% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{openPage}
\alias{openPage}
\title{Open a new empty page}
\usage{
openPage(
  useViewer = TRUE,
  rootDirectory = NULL,
  startPage = NULL,
  layout = NULL,
  port = NULL,
  browser = NULL,
  ...
)
}
\arguments{
\item{useViewer}{If \code{TRUE}, a page will be opened in the RStudio Viewer. If \code{FALSE},
a default web browser will be used.}

\item{rootDirectory}{A path to the root directory for the server. Any file, requested by the server
will be searched for in this directory. If \code{rootDirectory} is not
defined, the \code{http_root} in the package directory will be used as a root directory.}

\item{startPage}{A path to an HTML file that should be used as a starting page of the app.
It can be an absolute path to a local file, or it can be relative to the \code{rootDirectory}
or to the current R working directory. If \code{startPage} is not defined, an empty page will be used.
The file must have \emph{.html} extension.}

\item{layout}{Adds one of the defaults layouts to each new page. Currently, only tables of arbitrary
size are supported. To add a table, this parameter must be equal to \code{"tableNxM"}, where \code{N} is the
number of rows and \code{M} is the number of columns. Each cell will get an ID that consists of
a letter (indicating the row) and a number (indicating the column) (e.g. \code{B3} is an ID of
the second row and third column).}

\item{port}{Defines which TCP port the server will listen to. If not defined, random available port
will be used (see \code{\link[httpuv]{randomPort}}).}

\item{browser}{A browser in which to open a new web page.
If not defined, default browser will be used. For more information check \code{\link[utils]{browseURL}}.
If this argument is specified, \code{useViewer} will be ignored.}

\item{...}{Further arguments passed to \code{\link[jrc]{openPage}}. Check details for more information.}
}
\value{
A new instance of class \code{\link{LCApp}}.
}
\description{
\code{openPage} starts a server, establishes a web socket connection between it and the current
R session and loads linked-charts JS library with all the dependencies. This function initializes
an instance of class \code{\link{LCApp}} and stores it in the namespace of the package. If another
instance has already been stored (i.e. another app has been started with this function), the existing
app will be closed.
}
\details{
Argument \code{onStart} of \code{jrc} \code{\link[jrc]{openPage}} function is replaced in \code{rlc}
with \code{beforeLoad} and \code{afterLoad}. The reason for that is when the page opens, \code{rlc}
has to put there all the existing charts. Different situations may require some code be loaded before or after
that happens. \code{beforeLoad} and \code{afterLoad} provide a way to define two callback functions, each
receiving a \code{\link[jrc]{Session}} object as an argument and is called once for each new page.
\code{beforeLoad} runs before anything else has happened, while \code{afterLoad} is called after all the
existing charts have been added to the page.

This function initializes a new instance of class \code{\link{LCApp}} and wraps around methods
\code{startServer} and \code{openPage} of its parent class \code{\link[jrc]{App}}.
}
\examples{
\donttest{openPage()

openPage(useViewer = FALSE, layout = "table2x3")}

}
