% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeLAS.r
\name{write.las}
\alias{write.las}
\title{Write a .las or .laz file}
\usage{
write.las(file, header, data)
}
\arguments{
\item{file}{character. file path to .las or .laz file}

\item{header}{list. Can be partially recycled from another file (see \link{read.lasheader}) and
updated with \link{header_update} or generated with \link{header_create}.}

\item{data}{data.frame or data.table that contains the data to write in the file. Column names must
respect the imposed nomenclature (see details)}
}
\value{
void
}
\description{
Write a .las or .laz file. The user provides a table with the data in columns. Column names must
respect the specified allowed names (see details). A correct and complete header must also be provided.
This header can optionally be generated with \link{header_create}.
}
\details{
Allowed names are "X", "Y", "Z", "gpstime", "Intensity", "ReturnNumber", "NumberOfReturns",
"ScanDirectionFlag", "EdgeOfFlightline", "Classification", "ScanAngle", "UserData", "PointSourceID",
"R", "G", "B", "NIR". All other extra columns will be written in extra bytes attributes only if the
header specifically states these data should be saved into extra bytes attributes. To use the full
potential of the function \code{write.las} it is recommended users read the complete specifications of
the \href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}.
Otherwise users can rely on automated procedures that are expected to be sufficient for most usages.
}
\examples{
lasdata = data.frame(X = c(339002.889, 339002.983, 339002.918),
                     Y = c(5248000.515, 5248000.478, 5248000.318),
                     Z = c(975.589, 974.778, 974.471),
                     gpstime = c(269347.281418006, 269347.281428006, 269347.281438006),
                     Intensity = c(82L, 54L, 27L),
                     ReturnNumber = c(1L, 1L, 2L),
                     NumberOfReturns = c(1L, 1L, 2L),
                     ScanDirectionFlag = c(1L, 1L, 1L),
                     EdgeOfFlightline = c(1L, 0L, 0L),
                     Classification = c(1L, 1L, 1L),
                     ScanAngleRank = c(-21L, -21L, -21L),
                     UserData = c(32L, 32L, 32L),
                     PointSourceID = c(17L, 17L, 17L))

lasheader = header_create(lasdata)
file = file.path(tempdir(), "temp.laz")

write.las(file, lasheader, lasdata)
}
\seealso{
Other rlas: \code{\link{read.lasheader}}
}
\concept{rlas}
