% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call2}
\alias{call2}
\title{Create a call}
\usage{
call2(.fn, ..., .ns = NULL)
}
\arguments{
\item{.fn}{Function to call. Must be a callable object: a string,
symbol, call, or a function.}

\item{...}{Arguments to the call either in or out of a list. These dots
support \link[=tidy-dots]{tidy dots} features. Empty arguments are preserved.}

\item{.ns}{Namespace with which to prefix \code{.fn}. Must be a string
or symbol.}
}
\description{
Quoted function calls are one of the two types of
\link[=is_symbolic]{symbolic} objects in R. They represent the action of
calling a function, possibly with arguments. There are two ways of
creating a quoted call:
\itemize{
\item By \link[=quotation]{quoting} it. Quoting prevents functions from being
called. Instead, you get the description of the function call as
an R object. That is, a quoted function call.
\item By constructing it with \code{\link[base:call]{base::call()}}, \code{\link[base:as.call]{base::as.call()}}, or
\code{call2()}. In this case, you pass the call elements (the function
to call and the arguments to call it with) separately.
}

See section below for the difference between \code{call2()} and the base
constructors.
}
\section{Difference with base constructors}{


\code{call2()} is more flexible and convenient than \code{base::call()}:
\itemize{
\item The function to call can be a string or a \link[=is_callable]{callable}
object: a symbol, another call (e.g. a \code{$} or \code{[[} call), or a
function to inline. \code{base::call()} only supports strings and you
need to use \code{base::as.call()} to construct a call with a callable
object.\preformatted{call2(list, 1, 2)

as.call(list(list, 1, 2))
}
\item The \code{.ns} argument is convenient for creating namespaced calls.\preformatted{call2("list", 1, 2, .ns = "base")

ns_call <- as.call(list(as.name("::"), as.name("list"), as.name("base")))
as.call(list(ns_call, 1, 2))
}
\item \code{call2()} has \link[=list2]{tidy dots} support and you can splice lists
of arguments with \code{!!!}. With base R, you need to use \code{as.call()}
instead of \code{call()} if the arguments are in a list.\preformatted{args <- list(na.rm = TRUE, trim = 0)

call2("mean", 1:10, !!!args)

as.call(c(list(as.name("mean"), 1:10), args))
}
}
}

\section{Life cycle}{


In rlang 0.2.0 \code{lang()} was soft-deprecated and renamed to
\code{call2()}.

In early versions of rlang calls were called "language" objects in
order to follow the R type nomenclature as returned by
\code{\link[base:typeof]{base::typeof()}}. The goal was to avoid adding to the confusion
between S modes and R types. With hindsight we find it is better to
use more meaningful type names.
}

\examples{
# fn can either be a string, a symbol or a call
call2("f", a = 1)
call2(quote(f), a = 1)
call2(quote(f()), a = 1)

#' Can supply arguments individually or in a list
call2(quote(f), a = 1, b = 2)
call2(quote(f), !!!list(a = 1, b = 2))

# Creating namespaced calls is easy:
call2("fun", arg = quote(baz), .ns = "mypkg")

# Empty arguments are preserved:
call2("[", quote(x), , drop = )
}
\seealso{
call_modify
}
