% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval-tidy.R
\docType{data}
\name{tidyeval-data}
\alias{tidyeval-data}
\alias{.data}
\title{Data pronoun for tidy evaluation}
\usage{
.data
}
\description{
This pronoun allows you to be explicit when you refer to an object
inside the data. Referring to the \code{.data} pronoun rather than to
the original data frame has several advantages:
\itemize{
\item It makes it easy to refer to column names stored as strings. If
\code{var} contains the column \code{"height"}, the pronoun will subset that
column:\preformatted{var <- "height"
dplyr::summarise(df, mean(.data[[var]]))
}

The index variable \code{var} is \link[=quasiquotation]{unquoted}, which
ensures a column named \code{var} in the data frame cannot mask it.
This makes the pronoun safe to use in functions and packages.
\item Sometimes a computation is not about the whole data but about a
subset. For example if you supply a grouped data frame to a dplyr
verb, the \code{.data} pronoun contains the group subset.
\item It lets dplyr know that you're referring to a column from the
data which is helpful to generate correct queries when the source
is a database.
}

The \code{.data} object exported here is useful to import in your
package namespace to avoid a \code{R CMD check} note when referring to
objects from the data mask.
}
\keyword{datasets}
