% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quo-predicates}
\alias{quo-predicates}
\alias{quo_is_missing}
\alias{quo_is_symbol}
\alias{quo_is_lang}
\alias{quo_is_symbolic}
\alias{quo_is_null}
\title{Is a quosure quoting a symbolic, missing or NULL object?}
\usage{
quo_is_missing(quo)

quo_is_symbol(quo)

quo_is_lang(quo)

quo_is_symbolic(quo)

quo_is_null(quo)
}
\arguments{
\item{quo}{A quosure.}
}
\description{
These functions examine the expression of a quosure with a
predicate.
}
\section{Empty quosures}{


When missing arguments are captured as quosures, either through
\code{\link[=enquo]{enquo()}} or \code{\link[=quos]{quos()}}, they are returned as an empty quosure. These
quosures contain the \link[=missing_arg]{missing argument} and typically
have the \link[=empty_env]{empty environment} as enclosure.
}

\examples{
quo_is_symbol(quo(sym))
quo_is_symbol(quo(foo(bar)))

# You can create empty quosures by calling quo() without input:
quo <- quo()
quo_is_missing(quo)
is_missing(f_rhs(quo))
}
