% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsoncons.R
\name{version}
\alias{version}
\alias{jsonpath}
\alias{jmespath}
\title{Query the jsoncons C++ library}
\usage{
version()

jsonpath(data, path, object_names = "asis", ...)

jmespath(data, path, object_names = "asis", ...)
}
\arguments{
\item{data}{an \emph{R} object. If \code{data} is a scalar (length 1)
character vector, it is treated as a single JSON
string. Otherwise, it is parsed to a JSON string using
\code{jsonlite::toJSON()}. Use \code{I()} to treat a scalar character
vector as an \emph{R} object rather than JSON string, e.g., \code{I("A")}
will be parsed to \verb{["A"]} before processing.}

\item{path}{character(1) jsonpath or jmespath query string.}

\item{object_names}{character(1) order \code{data} object elements
\code{"asis"} (default) or \code{"sort"} before filtering on \code{path}.}

\item{...}{arguments passed to \code{jsonlite::toJSON} when \code{data} is
not a scalar character vector. For example, use \code{auto_unbox = TRUE} to automatically 'unbox' vectors of length 1 to JSON
scalar values.}
}
\value{
\code{version()} returns a character(1) major.minor.patch
version string .

\code{jsonpath()} returns a character(1) json string
representing the result of the query.

\code{jmespath()} return a character(1) json string representing
the result of the query.
}
\description{
\code{version()} reports the version of the C++ jsoncons
library in use.

\code{jsonpath()} executes a query against a json string
using the 'jsonpath' specification

\code{jmespath()} executes a query against a json string
using the 'jmespath' specification.
}
\examples{
version()

json <- '{
  "locations": [
    {"name": "Seattle", "state": "WA"},
    {"name": "New York", "state": "NY"},
    {"name": "Bellevue", "state": "WA"},
    {"name": "Olympia", "state": "WA"}
  ]
 }'

jsonpath(json, "$..name") |>
    cat("\n")

## create a list with state and name as scalar vectors
lst <- jsonlite::fromJSON(json, simplifyVector = FALSE)

## objects other than scalar character vectors are automatically
## coerced to JSON; use `auto_unbox = TRUE` to represent R scalar
## vectors in the object as JSON scalar vectors
jsonpath(lst, "$..name", auto_unbox = TRUE) |>
    cat("\n")

## a scalar character vector like "Seattle" is not valid JSON...
try(jsonpath("Seattle", "$[0]"))

## use I("Seattle") to coerce to a JSON object ["Seattle"]
jsonpath(I("Seattle"), "$[0]")      |> cat("\n")

## different ordering of object names -- 'asis' (default) or 'sort'
json_obj <- '{"b": "1", "a": "2"}'
jsonpath(json_obj, "$")             |> cat("\n")
jsonpath(json_obj, "$.*")           |> cat("\n")
jsonpath(json_obj, "$", "sort")   |> cat("\n")
jsonpath(json_obj, "$.*", "sort") |> cat("\n")

path <- "locations[?state == 'WA'].name | sort(@)"
jmespath(json, path) |>
    cat("\n")

## original filter always fails, e.g., '["WA"] != 'WA'
jmespath(lst, path)  # empty result set, '[]'

## filter with unboxed state, and return unboxed name
jmespath(lst, "locations[?state[0] == 'WA'].name[0] | sort(@)") |>
    cat("\n")

## automatically unbox scalar values when creating the JSON string
jmespath(lst, path, auto_unbox = TRUE) |>
    cat("\n")

}
