% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_trace.R
\name{rxp_trace}
\alias{rxp_trace}
\title{Trace lineage of derivations}
\usage{
rxp_trace(
  name = NULL,
  dag_file = file.path("_rixpress", "dag.json"),
  transitive = TRUE,
  include_self = FALSE
)
}
\arguments{
\item{name}{Character, defaults to NULL. Name of the derivation to inspect.
If NULL, the function prints the whole pipeline (inverted global view).}

\item{dag_file}{Character, defaults to "_rixpress/dag.json". Path to dag.json.}

\item{transitive}{Logical, defaults to TRUE. If TRUE, show transitive closure and
mark transitive-only nodes with "*". If FALSE, show immediate neighbours only.}

\item{include_self}{Logical, defaults to FALSE. If TRUE, include \code{name} itself in the results.}
}
\value{
Invisibly, a named list mapping each inspected derivation name to a
list with elements:
- dependencies
- reverse_dependencies
The function also prints a tree representation to the console.
}
\description{
Trace lineage of derivations
}
\seealso{
Other utilities: 
\code{\link{print.rxp_derivation}()},
\code{\link{rxp_copy}()},
\code{\link{rxp_gc}()},
\code{\link{rxp_init}()},
\code{\link{rxp_inspect}()},
\code{\link{rxp_list_logs}()},
\code{\link{rxp_load}()},
\code{\link{rxp_read}()}
}
\concept{utilities}
