% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plotROC}
\alias{plotROC}
\title{Plot ROC curves}
\usage{
plotROC(x, models, times, xlab = "1-Specificity", ylab = "Sensitivity", col,
  lwd = 3, lty = 1, cex = 1, pch = 1, legend = TRUE, add = FALSE,
  ...)
}
\arguments{
\item{x}{Object obtained with function \code{Score}}

\item{models}{Choice of models to plot}

\item{times}{A single time point specifying the prediction horizon}

\item{xlab}{Label for x-axis}

\item{ylab}{Label for y-axis}

\item{col}{line color}

\item{lwd}{line width}

\item{lty}{line style}

\item{cex}{point size}

\item{pch}{point style}

\item{legend}{logical. If \code{1L} draw a legend with the values of AUC.}

\item{add}{logical. If \code{1L} add lines to an existing plot.}

\item{...}{Used for additional control of the subroutines: plot,
axis, lines, legend. See \code{\link{SmartControl}}.}
}
\description{
Plot ROC curve
}
\examples{
## binary
set.seed(18)
library(randomForest)
library(survival)
bdl <- sampleData(40,outcome="binary")
bdt <- sampleData(58,outcome="binary")
bdl[,y:=factor(Y)]
bdt[,y:=factor(Y)]
fb1 <- glm(y~X1+X2+X3+X4+X5+X6+X7+X8+X9+X10,data=bdl,family="binomial")
fb2 <- randomForest(y~X1+X2+X3+X4+X5+X6+X7+X8+X9+X10,data=bdl)
xb <- Score(list("glm"=fb1,"rf"=fb2),y~1,data=bdt,
            plots="roc",metrics="auc")
plotROC(xb)
## survival
set.seed(18)
sdl <- sampleData(40,outcome="survival")
sdt <- sampleData(58,outcome="survival")
fs1 <- coxph(Surv(time,event)~X3+X5+X6+X7+X8+X10,data=sdl,x=TRUE)
fs2 <- coxph(Surv(time,event)~X1+X2+X9,data=sdl,x=TRUE)
xs <- Score(list(model1=fs1,model2=fs2),Hist(time,event)~1,data=sdt,
            times=5,plots="roc",metrics="auc")
plotROC(xs)
## competing risks
data(Melanoma)
f1 <- CSC(Hist(time,status)~age+sex+epicel+ulcer,data=Melanoma)
f2 <- CSC(Hist(time,status)~age+sex+logthick+epicel+ulcer,data=Melanoma)
x <- Score(list(model1=f1,model2=f2),Hist(time,status)~1,data=Melanoma,
            cause=1,times=5*365.25,plots="roc",metrics="auc")
plotROC(x)
}
