% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{CoxDesign}
\alias{CoxDesign}
\alias{CoxDesign.coxph}
\alias{CoxDesign.phreg}
\title{Extract the design matrix used to train a Cox model}
\usage{
CoxDesign(object, center)

\method{CoxDesign}{coxph}(object, center = FALSE)

\method{CoxDesign}{phreg}(object, center = FALSE)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}

\item{center}{logical. Should the variable of the linear predictor be centered ?}
}
\description{
Extract the design matrix used to train a Cox model. Should contain the time of event, the type of event, 
the variable for the linear predictor, the strata variables and the date of entry (in case of delayed entry).
}
\examples{
\dontrun{
set.seed(10)
d <- sampleData(2e1, outcome = "survival")
d$entry <- 0

##
library(survival)
mCox <- coxph(Surv(entry, time, event) ~ X1+X2, data = d, x = TRUE, y = TRUE)
CoxDesign(mCox)
mCox <- coxph(Surv(time, event) ~ X1*X2+strata(X3), data = d, x = TRUE, y = TRUE)
CoxDesign(mCox)
mCox <- coxph(Surv(time, event) ~ X1+X2+strata(X3)+strata(X4), data = d, x = TRUE, y = TRUE)
CoxDesign(mCox, center = TRUE)

##
library(rms)
mCox <- cph(Surv(time, event) ~ X1+X2, data = d, x = TRUE, y = TRUE)
CoxDesign(mCox)
mCox <- cph(Surv(time, event) ~ X1*X2+strat(X3), data = d, x = TRUE, y = TRUE)
CoxDesign(mCox, center = TRUE)
mCox <- cph(Surv(time, event) ~ X1*X2+strat(X3)+strat(X4), data = d, x = TRUE, y = TRUE)
CoxDesign(mCox)

##
library(mets) 
d$id <- 1:NROW(d)

mCox <- phreg(Surv(entry, time, event) ~ X1*X2, data = d)
CoxDesign(mCox)
mCox <- phreg(Surv(entry, time, event) ~ X1+X2+strata(X3)+cluster(id), data = d)
CoxDesign(mCox)
# mCox <- phreg(Surv(entry, time, event) ~ X1+X2+strata(X3)+strata(X4)+cluster(id), data = d)
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}
