% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{CoxCenter}
\alias{CoxCenter}
\alias{CoxCenter.cph}
\alias{CoxCenter.coxph}
\alias{CoxCenter.phreg}
\title{Extract the mean value of the covariates}
\usage{
CoxCenter(object)

\method{CoxCenter}{cph}(object)

\method{CoxCenter}{coxph}(object)

\method{CoxCenter}{phreg}(object)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}
}
\description{
Extract the mean value of the covariates
}
\examples{
\dontrun{
d <- sampleData(1e2, outcome = "survival")
d$Xcat <- paste0(d$X3,d$X4)
d$entry <- 0

##
library(survival)
mCox <- coxph(Surv(time, event) ~ X1+X2, data = d)
CoxCenter(mCox)
mCox <- coxph(Surv(time, event) ~ X1+X2+Xcat, data = d)
CoxCenter(mCox)

##
library(rms)
mCox <- cph(Surv(time, event) ~ X1+X2, data = d, y = TRUE)
CoxCenter(mCox)
mCox <- cph(Surv(time, event) ~ X1+X2+Xcat, data = d)
CoxCenter(mCox)

##
library(mets)
mCox <- phreg(Surv(entry, time, event) ~ X1+X2, data = d)
CoxCenter(mCox)
mCox <- cph(Surv(time, event) ~ X1+X2+Xcat, data = d)
CoxCenter(mCox)
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}
