% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iidCox.R
\name{iid}
\alias{iid}
\alias{iidCox}
\title{Extract i.i.d. decomposition from a Cox model}
\usage{
iidCox(object, newdata = NULL, tauHazard = NULL, keep.times = TRUE,
  center.result = TRUE)
}
\arguments{
\item{object}{object The fitted Cox regression model object either
obtained with \code{coxph} (survival package) or \code{cph}
(rms package).}

\item{newdata}{Optional new data at which to do i.i.d. decomposition}

\item{tauHazard}{the vector of times at which the i.i.d decomposition of the baseline hazard will be computed}

\item{keep.times}{Logical. If \code{TRUE} add the evaluation times to the output.}

\item{center.result}{Temporary argument. Should the IF be rescale to match timereg results.}

\item{...}{additional arguments}
}
\description{
Compute the influence function for each observation used to estimate the model
}
\details{
If there is no event in a strata, the influence function for the baseline hazard is set to 0.
}
\examples{
library(survival)
library(data.table)
set.seed(10)
d <- sampleData(40, outcome = "survival")[,.(eventtime,event,X1,X6)]
setkey(d, eventtime)

m.cox <- coxph(Surv(eventtime, event) ~ X1+X6, data = d, y = TRUE, x = TRUE)
system.time(IC.cox <- iidCox(m.cox))

IC.cox <- iidCox(m.cox, tauHazard = sort(unique(c(7,d$eventtime))))
 

}

